/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.zzab;
import com.google.android.gms.fitness.data.zzp;
import com.google.android.gms.fitness.data.zzr;
import com.google.android.gms.fitness.data.zzs;
import com.google.android.gms.fitness.data.zzx;
import com.google.android.gms.fitness.zza;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Goal
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final int OBJECTIVE_TYPE_METRIC = 1;
    public static final int OBJECTIVE_TYPE_DURATION = 2;
    public static final int OBJECTIVE_TYPE_FREQUENCY = 3;
    private final int versionCode;
    private final long zzguq;
    private final long zzgur;
    private final List<Integer> zzgus;
    private final Recurrence zzgut;
    private final int zzguu;
    private final MetricObjective zzguv;
    private final DurationObjective zzguw;
    private final FrequencyObjective zzgux;
    public static final Parcelable.Creator<Goal> CREATOR = new zzs();

    public long getCreateTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzguq, TimeUnit.NANOSECONDS);
    }

    public long getStartTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzgut != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzgut.zzgvb) {
                case 1: {
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzgut.zzgvb;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzguq, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzgut != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzgut.zzgvb) {
                case 1: {
                    calendar2.add(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.add(4, 1);
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.add(2, 1);
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzgut.zzgvb;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzgur, TimeUnit.NANOSECONDS);
    }

    @Nullable
    public String getActivityName() {
        if (this.zzgus.isEmpty() || this.zzgus.size() > 1) {
            return null;
        }
        return zza.getName(this.zzgus.get(0));
    }

    public Recurrence getRecurrence() {
        return this.zzgut;
    }

    public int getObjectiveType() {
        return this.zzguu;
    }

    private static String zzcz(int n) {
        switch (n) {
            case 1: {
                return "metric";
            }
            case 2: {
                return "duration";
            }
            case 3: {
                return "frequency";
            }
            case 0: {
                return "unknown";
            }
        }
        throw new IllegalArgumentException("invalid objective type value");
    }

    public MetricObjective getMetricObjective() {
        this.zzda(1);
        return this.zzguv;
    }

    public DurationObjective getDurationObjective() {
        this.zzda(2);
        return this.zzguw;
    }

    public FrequencyObjective getFrequencyObjective() {
        this.zzda(3);
        return this.zzgux;
    }

    Goal(int n, long l, long l2, List<Integer> list, Recurrence recurrence, int n2, MetricObjective metricObjective, DurationObjective durationObjective, FrequencyObjective frequencyObjective) {
        this.versionCode = n;
        this.zzguq = l;
        this.zzgur = l2;
        this.zzgus = list;
        this.zzgut = recurrence;
        this.zzguu = n2;
        this.zzguv = metricObjective;
        this.zzguw = durationObjective;
        this.zzgux = frequencyObjective;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Goal)) break block3;
                Goal goal = (Goal)((Object)object);
                Goal goal2 = this;
                if (!(goal2.zzguq == goal.zzguq && goal2.zzgur == goal.zzgur && zzbf.equal(goal2.zzgus, goal.zzgus) && zzbf.equal((Object)((Object)goal2.zzgut), (Object)((Object)goal.zzgut)) && goal2.zzguu == goal.zzguu && zzbf.equal((Object)((Object)goal2.zzguv), (Object)((Object)goal.zzguv)) && zzbf.equal((Object)((Object)goal2.zzguw), (Object)((Object)goal.zzguw)) && zzbf.equal((Object)((Object)goal2.zzgux), (Object)((Object)goal.zzgux)))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.zzguu;
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("activity", (Object)this.getActivityName()).zzg("recurrence", (Object)this.zzgut).zzg("metricObjective", (Object)this.zzguv).zzg("durationObjective", (Object)this.zzguw).zzg("frequencyObjective", (Object)this.zzgux).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Goal goal = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)goal.zzguq);
        zzd.zza((Parcel)parcel2, (int)2, (long)goal.zzgur);
        zzd.zzd((Parcel)parcel2, (int)3, goal.zzgus, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)goal.getRecurrence(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)goal.getObjectiveType());
        zzd.zza((Parcel)parcel2, (int)6, (Parcelable)goal.zzguv, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (Parcelable)goal.zzguw, (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)goal.versionCode);
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)goal.zzgux, (int)n, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    private final void zzda(int n) throws MismatchedGoalException {
        if (n != this.zzguu) {
            throw new MismatchedGoalException(String.format("%s goal does not have %s objective", Goal.zzcz(this.zzguu), Goal.zzcz(n)));
        }
    }

    public static class MismatchedGoalException
    extends IllegalStateException {
        public MismatchedGoalException(String string) {
            super(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ObjectiveType {
    }

    public static class FrequencyObjective
    extends com.google.android.gms.common.internal.safeparcel.zza {
        private final int versionCode;
        private final int frequency;
        public static final Parcelable.Creator<FrequencyObjective> CREATOR = new zzr();

        public int getFrequency() {
            return this.frequency;
        }

        FrequencyObjective(int n, int n2) {
            this.versionCode = n;
            this.frequency = n2;
        }

        public FrequencyObjective(int n) {
            this(1, n);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FrequencyObjective)) break block3;
                    FrequencyObjective frequencyObjective = (FrequencyObjective)((Object)object);
                    if (this.frequency != frequencyObjective.frequency) break block3;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.frequency;
        }

        public String toString() {
            return zzbf.zzt((Object)((Object)this)).zzg("frequency", (Object)this.frequency).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            FrequencyObjective frequencyObjective = this;
            int n2 = zzd.zze((Parcel)parcel2);
            zzd.zzc((Parcel)parcel2, (int)1, (int)frequencyObjective.getFrequency());
            zzd.zzc((Parcel)parcel2, (int)1000, (int)frequencyObjective.versionCode);
            zzd.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class DurationObjective
    extends com.google.android.gms.common.internal.safeparcel.zza {
        private final int versionCode;
        private final long zzguy;
        public static final Parcelable.Creator<DurationObjective> CREATOR = new zzp();

        public long getDuration(TimeUnit timeUnit) {
            return timeUnit.convert(this.zzguy, TimeUnit.NANOSECONDS);
        }

        DurationObjective(int n, long l) {
            this.versionCode = n;
            this.zzguy = l;
        }

        public DurationObjective(long l, TimeUnit timeUnit) {
            this(1, timeUnit.toNanos(l));
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DurationObjective)) break block3;
                    DurationObjective durationObjective = (DurationObjective)((Object)object);
                    if (!(this.zzguy == durationObjective.zzguy)) break block3;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.zzguy;
        }

        public String toString() {
            return zzbf.zzt((Object)((Object)this)).zzg("duration", (Object)this.zzguy).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            DurationObjective durationObjective = this;
            int n2 = zzd.zze((Parcel)parcel2);
            zzd.zza((Parcel)parcel2, (int)1, (long)durationObjective.zzguy);
            zzd.zzc((Parcel)parcel2, (int)1000, (int)durationObjective.versionCode);
            zzd.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class MetricObjective
    extends com.google.android.gms.common.internal.safeparcel.zza {
        private final int versionCode;
        private final String zzguz;
        private final double value;
        private final double zzgva;
        public static final Parcelable.Creator<MetricObjective> CREATOR = new zzx();

        public String getDataTypeName() {
            return this.zzguz;
        }

        public double getValue() {
            return this.value;
        }

        MetricObjective(int n, String string, double d, double d2) {
            this.versionCode = n;
            this.zzguz = string;
            this.value = d;
            this.zzgva = d2;
        }

        public MetricObjective(String string, double d) {
            this(1, string, d, 0.0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MetricObjective)) break block3;
                    MetricObjective metricObjective = (MetricObjective)((Object)object);
                    MetricObjective metricObjective2 = this;
                    if (!(zzbf.equal((Object)metricObjective2.zzguz, (Object)metricObjective.zzguz) && metricObjective2.value == metricObjective.value && metricObjective2.zzgva == metricObjective.zzgva)) break block3;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.zzguz.hashCode();
        }

        public String toString() {
            return zzbf.zzt((Object)((Object)this)).zzg("dataTypeName", (Object)this.zzguz).zzg("value", (Object)this.value).zzg("initialValue", (Object)this.zzgva).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            MetricObjective metricObjective = this;
            int n2 = zzd.zze((Parcel)parcel2);
            zzd.zza((Parcel)parcel2, (int)1, (String)metricObjective.getDataTypeName(), (boolean)false);
            zzd.zza((Parcel)parcel2, (int)2, (double)metricObjective.getValue());
            zzd.zza((Parcel)parcel2, (int)3, (double)metricObjective.zzgva);
            zzd.zzc((Parcel)parcel2, (int)1000, (int)metricObjective.versionCode);
            zzd.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class Recurrence
    extends com.google.android.gms.common.internal.safeparcel.zza {
        public static final int UNIT_DAY = 1;
        public static final int UNIT_WEEK = 2;
        public static final int UNIT_MONTH = 3;
        private final int versionCode;
        private final int count;
        private final int zzgvb;
        public static final Parcelable.Creator<Recurrence> CREATOR = new zzab();

        public int getCount() {
            return this.count;
        }

        public int getUnit() {
            return this.zzgvb;
        }

        Recurrence(int n, int n2, int n3) {
            this.versionCode = n;
            this.count = n2;
            zzbp.zzbg((n3 > 0 && n3 <= 3 ? 1 : 0) != 0);
            this.zzgvb = n3;
        }

        public Recurrence(int n, int n2) {
            this(1, n, n2);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Recurrence)) break block3;
                    Recurrence recurrence = (Recurrence)((Object)object);
                    Recurrence recurrence2 = this;
                    if (!(recurrence2.count == recurrence.count && recurrence2.zzgvb == recurrence.zzgvb)) break block3;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.zzgvb;
        }

        public String toString() {
            String string;
            zzbh zzbh2 = zzbf.zzt((Object)((Object)this)).zzg("count", (Object)this.count);
            switch (this.zzgvb) {
                case 1: {
                    string = "day";
                    break;
                }
                case 2: {
                    string = "week";
                    break;
                }
                case 3: {
                    string = "month";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid unit value");
                }
            }
            return zzbh2.zzg("unit", (Object)string).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Recurrence recurrence = this;
            int n2 = zzd.zze((Parcel)parcel2);
            zzd.zzc((Parcel)parcel2, (int)1, (int)recurrence.getCount());
            zzd.zzc((Parcel)parcel2, (int)2, (int)recurrence.getUnit());
            zzd.zzc((Parcel)parcel2, (int)1000, (int)recurrence.versionCode);
            zzd.zzai((Parcel)parcel2, (int)n2);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RecurrenceUnit {
        }
    }
}

