/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzh;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zzbsf;
import com.google.android.gms.internal.zzbsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends zza {
    private final int zzdxt;
    private final long zzdqy;
    private final long zzgrx;
    private final List<DataSource> zzgya;
    private final List<DataType> zzgrw;
    private final List<Session> zzgyb;
    private final boolean zzgyc;
    private final boolean zzgyd;
    private final zzbsf zzgxx;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzi();

    DataDeleteRequest(int n, long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.zzdxt = n;
        this.zzdqy = l;
        this.zzgrx = l2;
        this.zzgya = Collections.unmodifiableList(list);
        this.zzgrw = Collections.unmodifiableList(list2);
        this.zzgyb = list3;
        this.zzgyc = bl;
        this.zzgyd = bl2;
        this.zzgxx = zzbsg.zzay(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzdqy, builder.zzgrx, builder.zzgya, builder.zzgrw, builder.zzgyb, builder.zzgyc, builder.zzgyd, null);
    }

    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzbsf zzbsf2) {
        this(dataDeleteRequest.zzdqy, dataDeleteRequest.zzgrx, dataDeleteRequest.zzgya, dataDeleteRequest.zzgrw, dataDeleteRequest.zzgyb, dataDeleteRequest.zzgyc, dataDeleteRequest.zzgyd, zzbsf2);
    }

    private DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, zzbsf zzbsf2) {
        this.zzdxt = 3;
        this.zzdqy = l;
        this.zzgrx = l2;
        this.zzgya = Collections.unmodifiableList(list);
        this.zzgrw = Collections.unmodifiableList(list2);
        this.zzgyb = list3;
        this.zzgyc = bl;
        this.zzgyd = bl2;
        this.zzgxx = zzbsf2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdqy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgrx, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzgya;
    }

    public List<DataType> getDataTypes() {
        return this.zzgrw;
    }

    public List<Session> getSessions() {
        return this.zzgyb;
    }

    public boolean deleteAllData() {
        return this.zzgyc;
    }

    public boolean deleteAllSessions() {
        return this.zzgyd;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataDeleteRequest)) break block3;
                DataDeleteRequest dataDeleteRequest = (DataDeleteRequest)((Object)object);
                DataDeleteRequest dataDeleteRequest2 = this;
                if (!(dataDeleteRequest2.zzdqy == dataDeleteRequest.zzdqy && dataDeleteRequest2.zzgrx == dataDeleteRequest.zzgrx && zzbf.equal(dataDeleteRequest2.zzgya, dataDeleteRequest.zzgya) && zzbf.equal(dataDeleteRequest2.zzgrw, dataDeleteRequest.zzgrw) && zzbf.equal(dataDeleteRequest2.zzgyb, dataDeleteRequest.zzgyb) && dataDeleteRequest2.zzgyc == dataDeleteRequest.zzgyc && dataDeleteRequest2.zzgyd == dataDeleteRequest.zzgyd)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdqy, this.zzgrx});
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzdqy).zzg("endTimeMillis", (Object)this.zzgrx).zzg("dataSources", this.zzgya).zzg("dateTypes", this.zzgrw).zzg("sessions", this.zzgyb).zzg("deleteAllData", (Object)this.zzgyc).zzg("deleteAllSessions", (Object)this.zzgyd).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataDeleteRequest dataDeleteRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)dataDeleteRequest.zzdqy);
        zzd.zza((Parcel)parcel2, (int)2, (long)dataDeleteRequest.zzgrx);
        zzd.zzc((Parcel)parcel2, (int)3, dataDeleteRequest.getDataSources(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, dataDeleteRequest.getDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, dataDeleteRequest.getSessions(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (boolean)dataDeleteRequest.zzgyc);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)dataDeleteRequest.zzgyd);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataDeleteRequest.zzdxt);
        DataDeleteRequest dataDeleteRequest2 = dataDeleteRequest;
        zzd.zza((Parcel)parcel2, (int)8, (IBinder)(dataDeleteRequest2.zzgxx == null ? null : dataDeleteRequest2.zzgxx.asBinder()), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataDeleteRequest(Builder builder, zzh zzh2) {
        this(builder);
    }

    public static class Builder {
        private long zzdqy;
        private long zzgrx;
        private List<DataSource> zzgya = new ArrayList<DataSource>();
        private List<DataType> zzgrw = new ArrayList<DataType>();
        private List<Session> zzgyb = new ArrayList<Session>();
        private boolean zzgyc = false;
        private boolean zzgyd = false;

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbp.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbp.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzdqy = timeUnit.toMillis(l);
            this.zzgrx = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzbp.zzb((boolean)this.zzgrw.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzbp.zzb((boolean)this.zzgya.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzgyc = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzbp.zzb((!this.zzgyc ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzbp.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzgrw.contains((Object)dataType)) {
                this.zzgrw.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzbp.zzb((!this.zzgyc ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzbp.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzgya.contains((Object)dataSource)) {
                this.zzgya.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzbp.zzb((!this.zzgyd ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzbp.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzbp.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzgyb.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzbp.zzb((boolean)this.zzgyb.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzgyd = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzbp.zza((this.zzdqy > 0L && this.zzgrx > this.zzdqy ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzgyc || !this.zzgya.isEmpty() || !this.zzgrw.isEmpty();
            boolean bl2 = this.zzgyd || !this.zzgyb.isEmpty();
            zzbp.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            Builder builder = this;
            if (!builder.zzgyb.isEmpty()) {
                for (Session session : builder.zzgyb) {
                    zzbp.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= builder.zzdqy && session.getEndTime(TimeUnit.MILLISECONDS) <= builder.zzgrx ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, builder.zzdqy, builder.zzgrx});
                }
            }
            return new DataDeleteRequest(this, null);
        }
    }
}

