/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzl;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.internal.zzbqu;
import com.google.android.gms.internal.zzbqv;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends zza {
    public static final int NO_LIMIT = 0;
    private final int zzdxt;
    private final List<DataType> zzgrw;
    private final List<DataSource> zzgya;
    private final long zzdqy;
    private final long zzgrx;
    private final List<DataType> zzgyf;
    private final List<DataSource> zzgyg;
    private final int zzgsa;
    private final long zzgyh;
    private final DataSource zzgyi;
    private final int zzgyj;
    private final boolean zzgyk;
    private final boolean zzgyl;
    private final zzbqu zzgym;
    private final List<Device> zzgyn;
    private final List<Integer> zzgyo;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzm();

    DataReadRequest(int n, List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n2, long l3, DataSource dataSource, int n3, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5, List<Integer> list6) {
        this.zzdxt = n;
        this.zzgrw = list;
        this.zzgya = list2;
        this.zzdqy = l;
        this.zzgrx = l2;
        this.zzgyf = list3;
        this.zzgyg = list4;
        this.zzgsa = n2;
        this.zzgyh = l3;
        this.zzgyi = dataSource;
        this.zzgyj = n3;
        this.zzgyk = bl;
        this.zzgyl = bl2;
        this.zzgym = iBinder == null ? null : zzbqv.zzar(iBinder);
        this.zzgyn = list5 == null ? Collections.emptyList() : list5;
        this.zzgyo = list6 == null ? Collections.emptyList() : list6;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzgrw, builder.zzgya, builder.zzdqy, builder.zzgrx, builder.zzgyf, builder.zzgyg, builder.zzgsa, builder.zzgyh, builder.zzgyi, builder.zzgyj, false, builder.zzgyl, null, builder.zzgyn, builder.zzgyo);
    }

    public DataReadRequest(DataReadRequest dataReadRequest, zzbqu zzbqu2) {
        this(dataReadRequest.zzgrw, dataReadRequest.zzgya, dataReadRequest.zzdqy, dataReadRequest.zzgrx, dataReadRequest.zzgyf, dataReadRequest.zzgyg, dataReadRequest.zzgsa, dataReadRequest.zzgyh, dataReadRequest.zzgyi, dataReadRequest.zzgyj, dataReadRequest.zzgyk, dataReadRequest.zzgyl, zzbqu2, dataReadRequest.zzgyn, dataReadRequest.zzgyo);
    }

    private DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, zzbqu zzbqu2, List<Device> list5, List<Integer> list6) {
        this(6, list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zzbqu2 == null ? null : zzbqu2.asBinder(), list5, list6);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdqy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgrx, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzgrw;
    }

    public List<DataSource> getDataSources() {
        return this.zzgya;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzgyf;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzgyg;
    }

    public int getBucketType() {
        return this.zzgsa;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgyh, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzgyi;
    }

    public int getLimit() {
        return this.zzgyj;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadRequest)) break block3;
                DataReadRequest dataReadRequest = (DataReadRequest)((Object)object);
                DataReadRequest dataReadRequest2 = this;
                if (!(dataReadRequest2.zzgrw.equals(dataReadRequest.zzgrw) && dataReadRequest2.zzgya.equals(dataReadRequest.zzgya) && dataReadRequest2.zzdqy == dataReadRequest.zzdqy && dataReadRequest2.zzgrx == dataReadRequest.zzgrx && dataReadRequest2.zzgsa == dataReadRequest.zzgsa && dataReadRequest2.zzgyg.equals(dataReadRequest.zzgyg) && dataReadRequest2.zzgyf.equals(dataReadRequest.zzgyf) && zzbf.equal((Object)((Object)dataReadRequest2.zzgyi), (Object)((Object)dataReadRequest.zzgyi)) && dataReadRequest2.zzgyh == dataReadRequest.zzgyh && dataReadRequest2.zzgyl == dataReadRequest.zzgyl && dataReadRequest2.zzgyj == dataReadRequest.zzgyj && dataReadRequest2.zzgyk == dataReadRequest.zzgyk && zzbf.equal((Object)dataReadRequest2.zzgym, (Object)dataReadRequest.zzgym) && zzbf.equal(dataReadRequest2.zzgyn, dataReadRequest.zzgyn) && zzbf.equal(dataReadRequest2.zzgyo, dataReadRequest.zzgyo))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgsa, this.zzdqy, this.zzgrx});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzgrw.isEmpty()) {
            for (DataType zza2 : this.zzgrw) {
                stringBuilder.append(zza2.zzaor()).append(" ");
            }
        }
        if (!this.zzgya.isEmpty()) {
            for (DataSource dataSource : this.zzgya) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzgsa != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzcv(this.zzgsa));
            if (this.zzgyh > 0L) {
                stringBuilder.append(" >").append(this.zzgyh).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzgyf.isEmpty()) {
            for (DataType dataType : this.zzgyf) {
                stringBuilder.append(dataType.zzaor()).append(" ");
            }
        }
        if (!this.zzgyg.isEmpty()) {
            for (DataSource dataSource : this.zzgyg) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzdqy, this.zzdqy, this.zzgrx, this.zzgrx));
        if (this.zzgyi != null) {
            stringBuilder.append("activities: ").append(this.zzgyi.toDebugString());
        }
        if (!this.zzgyo.isEmpty()) {
            stringBuilder.append("quality: ");
            Iterator<Object> iterator = this.zzgyo.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stringBuilder.append(DataSource.zzcy(n)).append(" ");
            }
        }
        if (this.zzgyl) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public List<Integer> getFilteredDataQualityStandards() {
        return this.zzgyo;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadRequest dataReadRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, dataReadRequest.getDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, dataReadRequest.getDataSources(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)dataReadRequest.zzdqy);
        zzd.zza((Parcel)parcel2, (int)4, (long)dataReadRequest.zzgrx);
        zzd.zzc((Parcel)parcel2, (int)5, dataReadRequest.getAggregatedDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, dataReadRequest.getAggregatedDataSources(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)dataReadRequest.getBucketType());
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataReadRequest.zzdxt);
        zzd.zza((Parcel)parcel2, (int)8, (long)dataReadRequest.zzgyh);
        zzd.zza((Parcel)parcel2, (int)9, (Parcelable)dataReadRequest.getActivityDataSource(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)10, (int)dataReadRequest.getLimit());
        zzd.zza((Parcel)parcel2, (int)12, (boolean)dataReadRequest.zzgyk);
        zzd.zza((Parcel)parcel2, (int)13, (boolean)dataReadRequest.zzgyl);
        DataReadRequest dataReadRequest2 = dataReadRequest;
        zzd.zza((Parcel)parcel2, (int)14, (IBinder)(dataReadRequest2.zzgym == null ? null : dataReadRequest2.zzgym.asBinder()), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)16, dataReadRequest.zzgyn, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)17, dataReadRequest.getFilteredDataQualityStandards(), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataReadRequest(Builder builder, zzl zzl2) {
        this(builder);
    }

    public static class Builder {
        private List<DataType> zzgrw = new ArrayList<DataType>();
        private List<DataSource> zzgya = new ArrayList<DataSource>();
        private List<DataType> zzgyf = new ArrayList<DataType>();
        private List<DataSource> zzgyg = new ArrayList<DataSource>();
        private DataSource zzgyi;
        private long zzdqy;
        private long zzgrx;
        private int zzgsa = 0;
        private long zzgyh = 0L;
        private int zzgyj = 0;
        private boolean zzgyk = false;
        private boolean zzgyl = false;
        private final List<Device> zzgyn = new ArrayList<Device>();
        private final List<Integer> zzgyo = new ArrayList<Integer>();

        public Builder() {
        }

        public Builder read(DataSource dataSource) {
            zzbp.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbp.zzb((!this.zzgyg.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzgya.contains((Object)dataSource)) {
                this.zzgya.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbp.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbp.zza((!this.zzgyf.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzgrw.contains((Object)dataType)) {
                this.zzgrw.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzbp.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbp.zza((!this.zzgya.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            List<DataType> list = DataType.getAggregatesForInput(dataType2);
            zzbp.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzbp.zzb((boolean)list.contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.zzgyg.contains((Object)dataSource)) {
                this.zzgyg.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzbp.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbp.zza((!this.zzgrw.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            List<DataType> list = DataType.getAggregatesForInput(dataType);
            zzbp.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzbp.zzb((boolean)list.contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.zzgyf.contains((Object)dataType)) {
                this.zzgyf.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzbp.zzb((this.zzgsa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzgsa});
            zzbp.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzgsa = 1;
            this.zzgyh = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzbp.zzb((this.zzgsa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzgsa});
            zzbp.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzgsa = 3;
            this.zzgyh = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbp.zzb((this.zzgsa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzgsa});
            zzbp.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbp.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbp.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzgyi = dataSource;
            this.zzgsa = 3;
            this.zzgyh = timeUnit.toMillis(n);
            return this;
        }

        public Builder addFilteredDataQualityStandard(int n) {
            zzbp.zzb((boolean)this.zzgyn.isEmpty(), (Object)"Cannot add data quality standard filter when filtering by device.");
            this.zzgyo.add(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzbp.zzb((this.zzgsa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzgsa});
            zzbp.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzgsa = 4;
            this.zzgyh = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbp.zzb((this.zzgsa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzgsa});
            zzbp.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbp.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbp.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzgyi = dataSource;
            this.zzgsa = 4;
            this.zzgyh = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzbp.zzb((this.zzgsa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzgsa});
            zzbp.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzgsa = 2;
            this.zzgyh = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.zzdqy = timeUnit.toMillis(l);
            this.zzgrx = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzgyl = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzbp.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.zzgyj = n;
            return this;
        }

        public DataReadRequest build() {
            zzbp.zza((!this.zzgya.isEmpty() || !this.zzgrw.isEmpty() || !this.zzgyg.isEmpty() || !this.zzgyf.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzbp.zza((this.zzdqy > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzdqy});
            zzbp.zza((this.zzgrx > 0L && this.zzgrx > this.zzdqy ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzgrx});
            boolean bl = this.zzgyg.isEmpty() && this.zzgyf.isEmpty();
            zzbp.zza((bl && this.zzgsa == 0 || !bl && this.zzgsa != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this, null);
        }
    }
}

