/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzab;
import com.google.android.gms.fitness.request.zzac;
import com.google.android.gms.fitness.zza;
import com.google.android.gms.internal.zzbpe;
import com.google.android.gms.internal.zzbrd;
import com.google.android.gms.internal.zzbre;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoalsReadRequest
extends com.google.android.gms.common.internal.safeparcel.zza {
    private final int versionCode;
    private final zzbrd zzgyw;
    private final List<DataType> zzgyx;
    private final List<Integer> zzgyy;
    private final List<Integer> zzgus;
    public static final Parcelable.Creator<GoalsReadRequest> CREATOR = new zzac();

    public List<DataType> getDataTypes() {
        return this.zzgyx;
    }

    public List<Integer> getObjectiveTypes() {
        if (this.zzgyy.isEmpty()) {
            return null;
        }
        return this.zzgyy;
    }

    public List<String> getActivityNames() {
        if (this.zzgus.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : this.zzgus) {
            arrayList.add(zza.getName(n));
        }
        return arrayList;
    }

    GoalsReadRequest(int n, IBinder iBinder, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this.versionCode = n;
        this.zzgyw = iBinder == null ? null : zzbre.zzau(iBinder);
        this.zzgyx = list;
        this.zzgyy = list2;
        this.zzgus = list3;
    }

    private GoalsReadRequest(Builder builder) {
        this(null, builder.zzgyx, builder.zzgyy, builder.zzgus);
    }

    public GoalsReadRequest(GoalsReadRequest goalsReadRequest, zzbrd zzbrd2) {
        this(zzbrd2, goalsReadRequest.getDataTypes(), goalsReadRequest.zzgyy, goalsReadRequest.zzgus);
    }

    private GoalsReadRequest(zzbrd zzbrd2, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this(1, zzbrd2 == null ? null : zzbrd2.asBinder(), list, list2, list3);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GoalsReadRequest)) break block3;
                GoalsReadRequest goalsReadRequest = (GoalsReadRequest)((Object)object);
                GoalsReadRequest goalsReadRequest2 = this;
                if (!(zzbf.equal(goalsReadRequest2.zzgyx, goalsReadRequest.zzgyx) && zzbf.equal(goalsReadRequest2.zzgyy, goalsReadRequest.zzgyy) && zzbf.equal(goalsReadRequest2.zzgus, goalsReadRequest.zzgus))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgyx, this.zzgyy, this.getActivityNames()});
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("dataTypes", this.zzgyx).zzg("objectiveTypes", this.zzgyy).zzg("activities", this.getActivityNames()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoalsReadRequest goalsReadRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (IBinder)goalsReadRequest.zzgyw.asBinder(), (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)2, goalsReadRequest.getDataTypes(), (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)3, goalsReadRequest.zzgyy, (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)4, goalsReadRequest.zzgus, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)goalsReadRequest.versionCode);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ GoalsReadRequest(Builder builder, zzab zzab2) {
        this(builder);
    }

    public static class Builder {
        private final List<DataType> zzgyx = new ArrayList<DataType>();
        private final List<Integer> zzgyy = new ArrayList<Integer>();
        private final List<Integer> zzgus = new ArrayList<Integer>();

        public Builder() {
        }

        public Builder addDataType(DataType dataType) {
            zzbp.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzgyx.contains((Object)dataType)) {
                this.zzgyx.add(dataType);
            }
            return this;
        }

        public Builder addActivity(String string) {
            int n = zza.zzgw(string);
            zzbp.zza((n != 4 ? 1 : 0) != 0, (Object)"Attempting to add an unknown activity");
            zzbpe.zza(n, this.zzgus);
            return this;
        }

        public Builder addObjectiveType(int n) {
            zzbp.zza((n == 1 || n == 2 || n == 3 ? 1 : 0) != 0, (Object)"Attempting to add an invalid objective type");
            if (!this.zzgyy.contains(n)) {
                this.zzgyy.add(n);
            }
            return this;
        }

        public GoalsReadRequest build() {
            zzbp.zza((!this.zzgyx.isEmpty() ? 1 : 0) != 0, (Object)"At least one data type should be specified.");
            return new GoalsReadRequest(this, null);
        }
    }
}

