/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzap;
import com.google.android.gms.location.LocationRequest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzgtm;
    private final DataType zzgtn;
    private final long zzgvs;
    private final long zzgzg;
    private final long zzgzf;
    private final int zzgvt;
    private final LocationRequest zzgzk;
    private final long zzgzl;

    private SensorRequest(Builder builder) {
        this.zzgtm = builder.zzgtm;
        this.zzgtn = builder.zzgtn;
        this.zzgvs = builder.zzgvs;
        this.zzgzg = builder.zzgzg;
        this.zzgzf = builder.zzgzf;
        this.zzgvt = builder.zzgvt;
        this.zzgzk = null;
        this.zzgzl = builder.zzgzl;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        int n;
        this.zzgzk = locationRequest;
        this.zzgvs = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzgzg = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzgzf = this.zzgvs;
        this.zzgtn = dataSource.getDataType();
        switch (locationRequest.getPriority()) {
            case 100: {
                n = 3;
                break;
            }
            case 104: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        this.zzgvt = n;
        this.zzgtm = dataSource;
        long l = locationRequest.getExpirationTime();
        if (l == Long.MAX_VALUE) {
            this.zzgzl = Long.MAX_VALUE;
            return;
        }
        this.zzgzl = TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    public DataSource getDataSource() {
        return this.zzgtm;
    }

    public DataType getDataType() {
        return this.zzgtn;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgvs, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgzg, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgzf, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzgvt;
    }

    public final long zzaoz() {
        return this.zzgzl;
    }

    public String toString() {
        return zzbf.zzt((Object)this).zzg("dataSource", (Object)this.zzgtm).zzg("dataType", (Object)this.zzgtn).zzg("samplingRateMicros", (Object)this.zzgvs).zzg("deliveryLatencyMicros", (Object)this.zzgzf).zzg("timeOutMicros", (Object)this.zzgzl).toString();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SensorRequest)) break block3;
                SensorRequest sensorRequest = (SensorRequest)object;
                SensorRequest sensorRequest2 = this;
                if (!(zzbf.equal((Object)((Object)sensorRequest2.zzgtm), (Object)((Object)sensorRequest.zzgtm)) && zzbf.equal((Object)((Object)sensorRequest2.zzgtn), (Object)((Object)sensorRequest.zzgtn)) && sensorRequest2.zzgvs == sensorRequest.zzgvs && sensorRequest2.zzgzg == sensorRequest.zzgzg && sensorRequest2.zzgzf == sensorRequest.zzgzf && sensorRequest2.zzgvt == sensorRequest.zzgvt && zzbf.equal((Object)sensorRequest2.zzgzk, (Object)sensorRequest.zzgzk) && sensorRequest2.zzgzl == sensorRequest.zzgzl)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgtm, this.zzgtn, this.zzgvs, this.zzgzg, this.zzgzf, this.zzgvt, this.zzgzk, this.zzgzl});
    }

    /* synthetic */ SensorRequest(Builder builder, zzap zzap2) {
        this(builder);
    }

    public static class Builder {
        private DataSource zzgtm;
        private DataType zzgtn;
        private long zzgvs = -1L;
        private long zzgzg = 0L;
        private long zzgzf = 0L;
        private boolean zzgzm = false;
        private int zzgvt = 2;
        private long zzgzl = Long.MAX_VALUE;

        public Builder() {
        }

        public Builder setDataSource(DataSource dataSource) {
            this.zzgtm = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzgtn = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzbp.zzb((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzgvs = timeUnit.toMicros(l);
            if (!this.zzgzm) {
                this.zzgzg = this.zzgvs / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzbp.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzgzm = true;
            this.zzgzg = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzbp.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzgzf = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            int n2;
            switch (n) {
                case 1: 
                case 3: {
                    n2 = n;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            this.zzgvt = n2;
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzbp.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzbp.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzgzl = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzbp.zza((this.zzgtm != null || this.zzgtn != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzbp.zza((this.zzgtn == null || this.zzgtm == null || this.zzgtn.equals((Object)this.zzgtm.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this, null);
        }
    }
}

