/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzau;
import com.google.android.gms.fitness.request.zzav;
import com.google.android.gms.internal.zzbrz;
import com.google.android.gms.internal.zzbsa;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends zza {
    private final int zzdxt;
    private final String zzgzs;
    private final String mSessionId;
    private final long zzdqy;
    private final long zzgrx;
    private final List<DataType> zzgrw;
    private final List<DataSource> zzgya;
    private boolean zzgzt;
    private final boolean zzgyl;
    private final List<String> zzgzu;
    private final zzbrz zzgzv;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzav();

    SessionReadRequest(int n, String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.zzdxt = n;
        this.zzgzs = string;
        this.mSessionId = string2;
        this.zzdqy = l;
        this.zzgrx = l2;
        this.zzgrw = list;
        this.zzgya = list2;
        this.zzgzt = bl;
        this.zzgyl = bl2;
        this.zzgzu = list3;
        this.zzgzv = zzbsa.zzaw(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzgzs, builder.mSessionId, builder.zzdqy, builder.zzgrx, builder.zzgrw, builder.zzgya, builder.zzgzt, builder.zzgyl, builder.zzgzu, null);
    }

    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzbrz zzbrz2) {
        this(sessionReadRequest.zzgzs, sessionReadRequest.mSessionId, sessionReadRequest.zzdqy, sessionReadRequest.zzgrx, sessionReadRequest.zzgrw, sessionReadRequest.zzgya, sessionReadRequest.zzgzt, sessionReadRequest.zzgyl, sessionReadRequest.zzgzu, zzbrz2);
    }

    private SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, zzbrz zzbrz2) {
        this(5, string, string2, l, l2, list, list2, bl, bl2, list3, zzbrz2 == null ? null : zzbrz2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdqy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgrx, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzgzs;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public List<DataType> getDataTypes() {
        return this.zzgrw;
    }

    public List<DataSource> getDataSources() {
        return this.zzgya;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzgzt;
    }

    public List<String> getExcludedPackages() {
        return this.zzgzu;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadRequest)) break block3;
                SessionReadRequest sessionReadRequest = (SessionReadRequest)((Object)object);
                SessionReadRequest sessionReadRequest2 = this;
                if (!(zzbf.equal((Object)sessionReadRequest2.zzgzs, (Object)sessionReadRequest.zzgzs) && sessionReadRequest2.mSessionId.equals(sessionReadRequest.mSessionId) && sessionReadRequest2.zzdqy == sessionReadRequest.zzdqy && sessionReadRequest2.zzgrx == sessionReadRequest.zzgrx && zzbf.equal(sessionReadRequest2.zzgrw, sessionReadRequest.zzgrw) && zzbf.equal(sessionReadRequest2.zzgya, sessionReadRequest.zzgya) && sessionReadRequest2.zzgzt == sessionReadRequest.zzgzt && sessionReadRequest2.zzgzu.equals(sessionReadRequest.zzgzu) && sessionReadRequest2.zzgyl == sessionReadRequest.zzgyl)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgzs, this.mSessionId, this.zzdqy, this.zzgrx});
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("sessionName", (Object)this.zzgzs).zzg("sessionId", (Object)this.mSessionId).zzg("startTimeMillis", (Object)this.zzdqy).zzg("endTimeMillis", (Object)this.zzgrx).zzg("dataTypes", this.zzgrw).zzg("dataSources", this.zzgya).zzg("sessionsFromAllApps", (Object)this.zzgzt).zzg("excludedPackages", this.zzgzu).zzg("useServer", (Object)this.zzgyl).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadRequest sessionReadRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)sessionReadRequest.getSessionName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)sessionReadRequest.getSessionId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)sessionReadRequest.zzdqy);
        zzd.zza((Parcel)parcel2, (int)4, (long)sessionReadRequest.zzgrx);
        zzd.zzc((Parcel)parcel2, (int)5, sessionReadRequest.getDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, sessionReadRequest.getDataSources(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)sessionReadRequest.zzgzt);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)sessionReadRequest.zzdxt);
        zzd.zza((Parcel)parcel2, (int)8, (boolean)sessionReadRequest.zzgyl);
        zzd.zzb((Parcel)parcel2, (int)9, sessionReadRequest.getExcludedPackages(), (boolean)false);
        SessionReadRequest sessionReadRequest2 = sessionReadRequest;
        zzd.zza((Parcel)parcel2, (int)10, (IBinder)(sessionReadRequest2.zzgzv == null ? null : sessionReadRequest2.zzgzv.asBinder()), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionReadRequest(Builder builder, zzau zzau2) {
        this(builder);
    }

    public static class Builder {
        private String zzgzs;
        private String mSessionId;
        private long zzdqy = 0L;
        private long zzgrx = 0L;
        private List<DataType> zzgrw = new ArrayList<DataType>();
        private List<DataSource> zzgya = new ArrayList<DataSource>();
        private boolean zzgzt = false;
        private boolean zzgyl = false;
        private List<String> zzgzu = new ArrayList<String>();

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzdqy = timeUnit.toMillis(l);
            this.zzgrx = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.zzgzs = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.mSessionId = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzbp.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.zzgya.contains((Object)dataSource)) {
                this.zzgya.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbp.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzgrw.contains((Object)dataType)) {
                this.zzgrw.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzgzt = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzbp.zzb((Object)string, (Object)"Attempting to use a null package name");
            if (!this.zzgzu.contains(string)) {
                this.zzgzu.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzgyl = true;
            return this;
        }

        public SessionReadRequest build() {
            zzbp.zzb((this.zzdqy > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzdqy});
            zzbp.zzb((this.zzgrx > 0L && this.zzgrx > this.zzdqy ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzgrx});
            return new SessionReadRequest(this, null);
        }
    }
}

