/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzae;
import com.google.android.gms.fitness.result.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
extends zza
implements Result {
    private final int zzdxt;
    private final List<Session> zzgyb;
    private final List<zzae> zzhak;
    private final Status mStatus;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzh();

    SessionReadResult(int n, List<Session> list, List<zzae> list2, Status status) {
        this.zzdxt = n;
        this.zzgyb = list;
        this.zzhak = Collections.unmodifiableList(list2);
        this.mStatus = status;
    }

    private SessionReadResult(List<Session> list, List<zzae> list2, Status status) {
        this.zzdxt = 3;
        this.zzgyb = list;
        this.zzhak = Collections.unmodifiableList(list2);
        this.mStatus = status;
    }

    public static SessionReadResult zzae(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<zzae> arrayList2 = new ArrayList<zzae>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzgyb;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzbp.zzb((boolean)this.zzgyb.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzae zzae2 : this.zzhak) {
            if (!zzbf.equal((Object)((Object)session), (Object)((Object)zzae2.getSession())) || !dataType.equals((Object)zzae2.getDataSet().getDataType())) continue;
            arrayList.add(zzae2.getDataSet());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzbp.zzb((boolean)this.zzgyb.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzae zzae2 : this.zzhak) {
            if (!zzbf.equal((Object)((Object)session), (Object)((Object)zzae2.getSession()))) continue;
            arrayList.add(zzae2.getDataSet());
        }
        return arrayList;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadResult)) break block3;
                SessionReadResult sessionReadResult = (SessionReadResult)((Object)object);
                SessionReadResult sessionReadResult2 = this;
                if (!(sessionReadResult2.mStatus.equals((Object)sessionReadResult.mStatus) && zzbf.equal(sessionReadResult2.zzgyb, sessionReadResult.zzgyb) && zzbf.equal(sessionReadResult2.zzhak, sessionReadResult.zzhak))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mStatus, this.zzgyb, this.zzhak});
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("status", (Object)this.mStatus).zzg("sessions", this.zzgyb).zzg("sessionDataSets", this.zzhak).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadResult sessionReadResult = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, sessionReadResult.getSessions(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, sessionReadResult.zzhak, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)sessionReadResult.getStatus(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)sessionReadResult.zzdxt);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

