/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.fitness.BleApi;
import com.google.android.gms.fitness.FitnessOptions;
import com.google.android.gms.fitness.data.BleDevice;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.zzb;
import com.google.android.gms.fitness.zzc;
import com.google.android.gms.fitness.zzd;
import com.google.android.gms.internal.zzbve;
import com.google.android.gms.internal.zzbyi;
import com.google.android.gms.internal.zzcaf;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.List;

public class BleClient
extends GoogleApi<FitnessOptions> {
    private static final BleApi zzgyy = zzq.zzamk() ? new zzbyi() : new zzcaf();

    BleClient(@NonNull Context context, @NonNull FitnessOptions fitnessOptions) {
        super(context, zzbve.zzhen, (Api.ApiOptions)fitnessOptions, GoogleApi.zza.zzfmj);
    }

    BleClient(@NonNull Activity activity, @NonNull FitnessOptions fitnessOptions) {
        super(activity, zzbve.zzhen, (Api.ApiOptions)fitnessOptions, GoogleApi.zza.zzfmj);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public Task<Void> startBleScan(List<DataType> list, int n, BleScanCallback bleScanCallback) {
        if (!zzq.zzamk()) {
            return Tasks.forException((Exception)new ApiException(zzcaf.zzhfu));
        }
        zzci zzci2 = this.zza(bleScanCallback, BleScanCallback.class.getSimpleName());
        zzc zzc2 = new zzc(this, zzci2, zzci2, list, n);
        zzd zzd2 = new zzd(this, zzci2.zzajo(), zzci2);
        return this.zza(zzc2, zzd2);
    }

    public Task<Boolean> stopBleScan(BleScanCallback bleScanCallback) {
        if (!zzq.zzamk()) {
            return Tasks.forException((Exception)new ApiException(zzcaf.zzhfu));
        }
        return this.zza(zzcm.zzb((Object)bleScanCallback, (String)BleScanCallback.class.getSimpleName()));
    }

    public Task<Void> claimBleDevice(BleDevice bleDevice) {
        return zzbj.zzb(zzgyy.claimBleDevice(this.zzago(), bleDevice));
    }

    public Task<Void> claimBleDevice(String string) {
        return zzbj.zzb(zzgyy.claimBleDevice(this.zzago(), string));
    }

    public Task<Void> unclaimBleDevice(String string) {
        return zzbj.zzb(zzgyy.unclaimBleDevice(this.zzago(), string));
    }

    public Task<Void> unclaimBleDevice(BleDevice bleDevice) {
        return zzbj.zzb(zzgyy.unclaimBleDevice(this.zzago(), bleDevice));
    }

    public Task<List<BleDevice>> listClaimedBleDevices() {
        return zzbj.zza(zzgyy.listClaimedBleDevices(this.zzago()), (zzbo)zzb.zzgnw);
    }
}

