/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Response;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.FitnessOptions;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateListenerRegistrationRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DataReadResponse;
import com.google.android.gms.fitness.zzj;
import com.google.android.gms.fitness.zzk;
import com.google.android.gms.internal.zzbvv;
import com.google.android.gms.internal.zzbyy;
import com.google.android.gms.tasks.Task;

public class HistoryClient
extends GoogleApi<FitnessOptions> {
    private static final HistoryApi zzgzl = new zzbyy();

    HistoryClient(@NonNull Context context, @NonNull FitnessOptions fitnessOptions) {
        super(context, zzbvv.zzhen, (Api.ApiOptions)fitnessOptions, GoogleApi.zza.zzfmj);
    }

    HistoryClient(@NonNull Activity activity, @NonNull FitnessOptions fitnessOptions) {
        super(activity, zzbvv.zzhen, (Api.ApiOptions)fitnessOptions, GoogleApi.zza.zzfmj);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public Task<DataReadResponse> readData(DataReadRequest dataReadRequest) {
        return zzbj.zza(zzgzl.readData(this.zzago(), dataReadRequest), (Response)new DataReadResponse());
    }

    public Task<DataSet> readDailyTotal(DataType dataType) {
        return zzbj.zza(zzgzl.readDailyTotal(this.zzago(), dataType), (zzbo)zzj.zzgnw);
    }

    public Task<DataSet> readDailyTotalFromLocalDevice(DataType dataType) {
        return zzbj.zza(zzgzl.readDailyTotalFromLocalDevice(this.zzago(), dataType), (zzbo)zzk.zzgnw);
    }

    public Task<Void> insertData(DataSet dataSet) {
        return zzbj.zzb(zzgzl.insertData(this.zzago(), dataSet));
    }

    public Task<Void> deleteData(DataDeleteRequest dataDeleteRequest) {
        return zzbj.zzb(zzgzl.deleteData(this.zzago(), dataDeleteRequest));
    }

    public Task<Void> updateData(DataUpdateRequest dataUpdateRequest) {
        return zzbj.zzb(zzgzl.updateData(this.zzago(), dataUpdateRequest));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public Task<Void> registerDataUpdateListener(DataUpdateListenerRegistrationRequest dataUpdateListenerRegistrationRequest) {
        return zzbj.zzb(zzgzl.registerDataUpdateListener(this.zzago(), dataUpdateListenerRegistrationRequest));
    }

    public Task<Void> unregisterDataUpdateListener(PendingIntent pendingIntent) {
        return zzbj.zzb(zzgzl.unregisterDataUpdateListener(this.zzago(), pendingIntent));
    }
}

