/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zzf;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbuy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends zzbfm
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzgzh;
    private final DataType zzgzg;
    private final List<DataPoint> zzham;
    private final List<DataSource> zzhan;
    private boolean zzhao = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zzi();

    DataSet(int n, DataSource dataSource, DataType dataType, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.versionCode = n;
        this.zzgzh = dataSource;
        this.zzgzg = dataSource.getDataType();
        this.zzhao = bl;
        this.zzham = new ArrayList<DataPoint>(list.size());
        this.zzhan = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.zzham.add(new DataPoint(this.zzhan, rawDataPoint));
        }
    }

    private DataSet(DataSource dataSource) {
        this.versionCode = 3;
        this.zzgzh = (DataSource)((Object)zzbq.checkNotNull((Object)((Object)dataSource)));
        this.zzgzg = dataSource.getDataType();
        this.zzham = new ArrayList<DataPoint>();
        this.zzhan = new ArrayList<DataSource>();
        this.zzhan.add(this.zzgzh);
    }

    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.versionCode = 3;
        int n = rawDataSet.zzhdo;
        List<DataSource> list2 = list;
        this.zzgzh = n >= 0 && n < list2.size() ? list2.get(n) : null;
        this.zzgzg = this.zzgzh.getDataType();
        this.zzhan = list;
        this.zzhao = rawDataSet.zzhad;
        List<RawDataPoint> list3 = rawDataSet.zzhdt;
        this.zzham = new ArrayList<DataPoint>(list3.size());
        for (RawDataPoint rawDataPoint : list3) {
            this.zzham.add(new DataPoint(this.zzhan, rawDataPoint));
        }
    }

    public static DataSet create(DataSource dataSource) {
        zzbq.checkNotNull((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public final DataPoint createDataPoint() {
        return DataPoint.create(this.zzgzh);
    }

    public final void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzbq.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzgzh.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzgzh});
        dataPoint.zzaqj();
        DataSet.zzb(dataPoint);
        this.zza(dataPoint);
    }

    private final void zza(DataPoint dataPoint) {
        this.zzham.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzhan.contains((Object)dataSource)) {
            this.zzhan.add(dataSource);
        }
    }

    public final void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    public final void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zza(dataPoint);
        }
    }

    public final DataSource getDataSource() {
        return this.zzgzh;
    }

    public final DataType getDataType() {
        return this.zzgzh.getDataType();
    }

    public final List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzham);
    }

    public final boolean isEmpty() {
        return this.zzham.isEmpty();
    }

    public final boolean zzaqd() {
        return this.zzhao;
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataSet)) break block3;
                DataSet dataSet = (DataSet)((Object)object);
                DataSet dataSet2 = this;
                if (!(zzbg.equal((Object)((Object)dataSet2.getDataType()), (Object)((Object)dataSet.getDataType())) && zzbg.equal((Object)((Object)dataSet2.zzgzh), (Object)((Object)dataSet.zzgzh)) && zzbg.equal(dataSet2.zzham, dataSet.zzham) && dataSet2.zzhao == dataSet.zzhao)) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgzh});
    }

    public final String toString() {
        List<RawDataPoint> list = this.zzaqk();
        return String.format("DataSet{%s %s}", this.zzgzh.toDebugString(), this.zzham.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzham.size(), list.subList(0, 5)));
    }

    public static void zzb(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zzbuy.zza(dataPoint, zzf.zzhae);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }

    private List<RawDataPoint> zzaqk() {
        return this.zzab(this.zzhan);
    }

    final List<RawDataPoint> zzab(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzham.size());
        for (DataPoint dataPoint : this.zzham) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSet dataSet = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (Parcelable)dataSet.getDataSource(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)dataSet.getDataType(), (int)n, (boolean)false);
        zzbfp.zzd((Parcel)parcel2, (int)3, dataSet.zzaqk(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)4, dataSet.zzhan, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (boolean)dataSet.zzhao);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)dataSet.versionCode);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

