/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.zzo;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbux;
import com.google.android.gms.internal.zzcaj;
import java.util.Arrays;

public final class Device
extends zzbfm {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    public static final int TYPE_HEAD_MOUNTED = 6;
    private final int versionCode;
    private final String zzhbt;
    private final String zzhbu;
    private final String version;
    private final String zzhbv;
    private final int type;
    private final int zzhbw;
    public static final Parcelable.Creator<Device> CREATOR = new zzo();

    public static Device getLocalDevice(Context context) {
        int n = zzbux.zzdg(context);
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    public Device(String string, String string2, String string3, int n) {
        this(string, string2, "", string3, n, 0);
    }

    private Device(String string, String string2, String string3, String string4, int n, int n2) {
        this(1, string, string2, "", string4, n, n2);
    }

    Device(int n, String string, String string2, String string3, String string4, int n2, int n3) {
        this.versionCode = n;
        this.zzhbt = (String)zzbq.checkNotNull((Object)string);
        this.zzhbu = (String)zzbq.checkNotNull((Object)string2);
        this.version = "";
        String string5 = string4;
        if (string5 == null) {
            throw new IllegalStateException("Device UID is null.");
        }
        this.zzhbv = string5;
        this.type = n2;
        this.zzhbw = n3;
    }

    public final String getManufacturer() {
        return this.zzhbt;
    }

    public final String getModel() {
        return this.zzhbu;
    }

    public final String getUid() {
        return this.zzhbv;
    }

    public final int getType() {
        return this.type;
    }

    final String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzhbt, this.zzhbu, this.zzhbv);
    }

    public final String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.version, this.type, this.zzhbw);
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Device)) break block3;
                Device device = (Device)((Object)object);
                Device device2 = this;
                if (!(zzbg.equal((Object)device2.zzhbt, (Object)device.zzhbt) && zzbg.equal((Object)device2.zzhbu, (Object)device.zzhbu) && zzbg.equal((Object)device2.version, (Object)device.version) && zzbg.equal((Object)device2.zzhbv, (Object)device.zzhbv) && device2.type == device.type && device2.zzhbw == device.zzhbw)) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhbt, this.zzhbu, this.version, this.zzhbv, this.type});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Device device = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (String)device.getManufacturer(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)device.getModel(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (String)device.version, (boolean)false);
        Device device2 = device;
        zzbfp.zza((Parcel)parcel2, (int)4, (String)(device2.zzhbw == 1 ? device2.zzhbv : zzcaj.zzho(device2.zzhbv)), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)5, (int)device.getType());
        zzbfp.zzc((Parcel)parcel2, (int)6, (int)device.zzhbw);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)device.versionCode);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

