/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.zzac;
import com.google.android.gms.fitness.data.zzad;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.fitness.zza;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbfr;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class Session
extends zzbfm {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int zzeck;
    private final long zzdvq;
    private final long zzgzz;
    private final String mName;
    private final String zzhdu;
    private final String zzdrs;
    private final int zzhaa;
    private final zzb zzhdv;
    private final Long zzhdw;
    public static final Parcelable.Creator<Session> CREATOR = new zzad();

    Session(int n, long l, long l2, String string, String string2, String string3, int n2, zzb zzb2, Long l3) {
        this.zzeck = n;
        this.zzdvq = l;
        this.zzgzz = l2;
        this.mName = string;
        this.zzhdu = string2;
        this.zzdrs = string3;
        this.zzhaa = n2;
        this.zzhdv = zzb2;
        this.zzhdw = l3;
    }

    private Session(long l, long l2, String string, String string2, String string3, int n, zzb zzb2, Long l3) {
        this(3, l, l2, string, string2, string3, n, null, l3);
    }

    private Session(Builder builder) {
        this(builder.zzdvq, builder.zzgzz, builder.mName, builder.zzhdu, builder.zzdrs, builder.zzhaa, null, builder.zzhdw);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzbfr.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdvq, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgzz, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzbq.zza((this.zzhdw != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzhdw, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzhdw != null;
    }

    public boolean isOngoing() {
        return this.zzgzz == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzhdu;
    }

    public String getDescription() {
        return this.zzdrs;
    }

    public String getActivity() {
        return zza.getName(this.zzhaa);
    }

    public String getAppPackageName() {
        if (this.zzhdv == null) {
            return null;
        }
        return this.zzhdv.getPackageName();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof Session)) break block3;
                Session session = (Session)((Object)object);
                Session session2 = this;
                if (!(session2.zzdvq == session.zzdvq && session2.zzgzz == session.zzgzz && zzbg.equal((Object)session2.mName, (Object)session.mName) && zzbg.equal((Object)session2.zzhdu, (Object)session.zzhdu) && zzbg.equal((Object)session2.zzdrs, (Object)session.zzdrs) && zzbg.equal((Object)((Object)session2.zzhdv), (Object)((Object)session.zzhdv)) && session2.zzhaa == session.zzhaa)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdvq, this.zzgzz, this.zzhdu});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("startTime", (Object)this.zzdvq).zzg("endTime", (Object)this.zzgzz).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzhdu).zzg("description", (Object)this.zzdrs).zzg("activity", (Object)this.zzhaa).zzg("application", (Object)this.zzhdv).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Session session = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (long)session.zzdvq);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)session.zzgzz);
        zzbfp.zza((Parcel)parcel2, (int)3, (String)session.getName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (String)session.getIdentifier(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (String)session.getDescription(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)7, (int)session.zzhaa);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)session.zzeck);
        zzbfp.zza((Parcel)parcel2, (int)8, (Parcelable)session.zzhdv, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)9, (Long)session.zzhdw, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ Session(Builder builder, zzac zzac2) {
        this(builder);
    }

    public static class Builder {
        private long zzdvq = 0L;
        private long zzgzz = 0L;
        private String mName = null;
        private String zzhdu;
        private String zzdrs;
        private int zzhaa = 4;
        private Long zzhdw;

        public Builder() {
        }

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzbq.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzdvq = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzbq.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzgzz = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzbq.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzbq.checkArgument((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.zzhdu = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzbq.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzdrs = string;
            return this;
        }

        public Builder setActivity(String string) {
            int n = zza.zzhc(string);
            Builder builder = this;
            this.zzhaa = n;
            return builder;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.zzhdw = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzbq.zza((this.zzdvq > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzbq.zza((this.zzgzz == 0L || this.zzgzz > this.zzdvq ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzhdu == null) {
                String string = this.mName == null ? "" : this.mName;
                long l = this.zzdvq;
                this.zzhdu = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            if (this.zzdrs == null) {
                this.zzdrs = "";
            }
            return new Session(this, null);
        }
    }
}

