/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.fitness.request.zzj;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbyf;
import com.google.android.gms.internal.zzbyg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends zzbfm {
    private final int zzeck;
    private final long zzdvq;
    private final long zzgzz;
    private final List<DataSource> zzhgf;
    private final List<DataType> zzgzy;
    private final List<Session> zzhgg;
    private final boolean zzhgh;
    private final boolean zzhgi;
    private final zzbyf zzhgc;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzj();

    DataDeleteRequest(int n, long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.zzeck = n;
        this.zzdvq = l;
        this.zzgzz = l2;
        this.zzhgf = Collections.unmodifiableList(list);
        this.zzgzy = Collections.unmodifiableList(list2);
        this.zzhgg = list3;
        this.zzhgh = bl;
        this.zzhgi = bl2;
        this.zzhgc = zzbyg.zzba(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzdvq, builder.zzgzz, builder.zzhgf, builder.zzgzy, builder.zzhgg, builder.zzhgh, builder.zzhgi, null);
    }

    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzbyf zzbyf2) {
        this(dataDeleteRequest.zzdvq, dataDeleteRequest.zzgzz, dataDeleteRequest.zzhgf, dataDeleteRequest.zzgzy, dataDeleteRequest.zzhgg, dataDeleteRequest.zzhgh, dataDeleteRequest.zzhgi, zzbyf2);
    }

    private DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, zzbyf zzbyf2) {
        this.zzeck = 3;
        this.zzdvq = l;
        this.zzgzz = l2;
        this.zzhgf = Collections.unmodifiableList(list);
        this.zzgzy = Collections.unmodifiableList(list2);
        this.zzhgg = list3;
        this.zzhgh = bl;
        this.zzhgi = bl2;
        this.zzhgc = zzbyf2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdvq, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgzz, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzhgf;
    }

    public List<DataType> getDataTypes() {
        return this.zzgzy;
    }

    public List<Session> getSessions() {
        return this.zzhgg;
    }

    public boolean deleteAllData() {
        return this.zzhgh;
    }

    public boolean deleteAllSessions() {
        return this.zzhgi;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataDeleteRequest)) break block3;
                DataDeleteRequest dataDeleteRequest = (DataDeleteRequest)((Object)object);
                DataDeleteRequest dataDeleteRequest2 = this;
                if (!(dataDeleteRequest2.zzdvq == dataDeleteRequest.zzdvq && dataDeleteRequest2.zzgzz == dataDeleteRequest.zzgzz && zzbg.equal(dataDeleteRequest2.zzhgf, dataDeleteRequest.zzhgf) && zzbg.equal(dataDeleteRequest2.zzgzy, dataDeleteRequest.zzgzy) && zzbg.equal(dataDeleteRequest2.zzhgg, dataDeleteRequest.zzhgg) && dataDeleteRequest2.zzhgh == dataDeleteRequest.zzhgh && dataDeleteRequest2.zzhgi == dataDeleteRequest.zzhgi)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdvq, this.zzgzz});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzdvq).zzg("endTimeMillis", (Object)this.zzgzz).zzg("dataSources", this.zzhgf).zzg("dateTypes", this.zzgzy).zzg("sessions", this.zzhgg).zzg("deleteAllData", (Object)this.zzhgh).zzg("deleteAllSessions", (Object)this.zzhgi).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataDeleteRequest dataDeleteRequest = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (long)dataDeleteRequest.zzdvq);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)dataDeleteRequest.zzgzz);
        zzbfp.zzc((Parcel)parcel2, (int)3, dataDeleteRequest.getDataSources(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)4, dataDeleteRequest.getDataTypes(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)5, dataDeleteRequest.getSessions(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (boolean)dataDeleteRequest.zzhgh);
        zzbfp.zza((Parcel)parcel2, (int)7, (boolean)dataDeleteRequest.zzhgi);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)dataDeleteRequest.zzeck);
        DataDeleteRequest dataDeleteRequest2 = dataDeleteRequest;
        zzbfp.zza((Parcel)parcel2, (int)8, (IBinder)(dataDeleteRequest2.zzhgc == null ? null : dataDeleteRequest2.zzhgc.asBinder()), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataDeleteRequest(Builder builder, zzi zzi2) {
        this(builder);
    }

    public static class Builder {
        private long zzdvq;
        private long zzgzz;
        private List<DataSource> zzhgf = new ArrayList<DataSource>();
        private List<DataType> zzgzy = new ArrayList<DataType>();
        private List<Session> zzhgg = new ArrayList<Session>();
        private boolean zzhgh = false;
        private boolean zzhgi = false;

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbq.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbq.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzdvq = timeUnit.toMillis(l);
            this.zzgzz = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzbq.checkArgument((boolean)this.zzgzy.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzbq.checkArgument((boolean)this.zzhgf.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzhgh = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzbq.checkArgument((!this.zzhgh ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzbq.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzgzy.contains((Object)dataType)) {
                this.zzgzy.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzbq.checkArgument((!this.zzhgh ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzbq.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzhgf.contains((Object)dataSource)) {
                this.zzhgf.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzbq.checkArgument((!this.zzhgi ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzbq.checkArgument((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzbq.checkArgument((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzhgg.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzbq.checkArgument((boolean)this.zzhgg.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzhgi = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzbq.zza((this.zzdvq > 0L && this.zzgzz > this.zzdvq ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzhgh || !this.zzhgf.isEmpty() || !this.zzgzy.isEmpty();
            boolean bl2 = this.zzhgi || !this.zzhgg.isEmpty();
            zzbq.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            Builder builder = this;
            if (!builder.zzhgg.isEmpty()) {
                for (Session session : builder.zzhgg) {
                    zzbq.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= builder.zzdvq && session.getEndTime(TimeUnit.MILLISECONDS) <= builder.zzgzz ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, builder.zzdvq, builder.zzgzz});
                }
            }
            return new DataDeleteRequest(this, null);
        }
    }
}

