/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzav;
import com.google.android.gms.fitness.request.zzaw;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbxz;
import com.google.android.gms.internal.zzbya;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends zzbfm {
    private final int zzeck;
    private final String zzhhx;
    private final String mSessionId;
    private final long zzdvq;
    private final long zzgzz;
    private final List<DataType> zzgzy;
    private final List<DataSource> zzhgf;
    private boolean zzhhy;
    private final boolean zzhgq;
    private final List<String> zzhhz;
    private final zzbxz zzhia;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzaw();

    SessionReadRequest(int n, String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.zzeck = n;
        this.zzhhx = string;
        this.mSessionId = string2;
        this.zzdvq = l;
        this.zzgzz = l2;
        this.zzgzy = list;
        this.zzhgf = list2;
        this.zzhhy = bl;
        this.zzhgq = bl2;
        this.zzhhz = list3;
        this.zzhia = zzbya.zzay(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzhhx, builder.mSessionId, builder.zzdvq, builder.zzgzz, builder.zzgzy, builder.zzhgf, builder.zzhhy, builder.zzhgq, builder.zzhhz, null);
    }

    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzbxz zzbxz2) {
        this(sessionReadRequest.zzhhx, sessionReadRequest.mSessionId, sessionReadRequest.zzdvq, sessionReadRequest.zzgzz, sessionReadRequest.zzgzy, sessionReadRequest.zzhgf, sessionReadRequest.zzhhy, sessionReadRequest.zzhgq, sessionReadRequest.zzhhz, zzbxz2);
    }

    private SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, zzbxz zzbxz2) {
        this(5, string, string2, l, l2, list, list2, bl, bl2, list3, zzbxz2 == null ? null : zzbxz2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzdvq, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzgzz, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzhhx;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public List<DataType> getDataTypes() {
        return this.zzgzy;
    }

    public List<DataSource> getDataSources() {
        return this.zzhgf;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzhhy;
    }

    public List<String> getExcludedPackages() {
        return this.zzhhz;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadRequest)) break block3;
                SessionReadRequest sessionReadRequest = (SessionReadRequest)((Object)object);
                SessionReadRequest sessionReadRequest2 = this;
                if (!(zzbg.equal((Object)sessionReadRequest2.zzhhx, (Object)sessionReadRequest.zzhhx) && sessionReadRequest2.mSessionId.equals(sessionReadRequest.mSessionId) && sessionReadRequest2.zzdvq == sessionReadRequest.zzdvq && sessionReadRequest2.zzgzz == sessionReadRequest.zzgzz && zzbg.equal(sessionReadRequest2.zzgzy, sessionReadRequest.zzgzy) && zzbg.equal(sessionReadRequest2.zzhgf, sessionReadRequest.zzhgf) && sessionReadRequest2.zzhhy == sessionReadRequest.zzhhy && sessionReadRequest2.zzhhz.equals(sessionReadRequest.zzhhz) && sessionReadRequest2.zzhgq == sessionReadRequest.zzhgq)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhx, this.mSessionId, this.zzdvq, this.zzgzz});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("sessionName", (Object)this.zzhhx).zzg("sessionId", (Object)this.mSessionId).zzg("startTimeMillis", (Object)this.zzdvq).zzg("endTimeMillis", (Object)this.zzgzz).zzg("dataTypes", this.zzgzy).zzg("dataSources", this.zzhgf).zzg("sessionsFromAllApps", (Object)this.zzhhy).zzg("excludedPackages", this.zzhhz).zzg("useServer", (Object)this.zzhgq).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadRequest sessionReadRequest = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (String)sessionReadRequest.getSessionName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)sessionReadRequest.getSessionId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (long)sessionReadRequest.zzdvq);
        zzbfp.zza((Parcel)parcel2, (int)4, (long)sessionReadRequest.zzgzz);
        zzbfp.zzc((Parcel)parcel2, (int)5, sessionReadRequest.getDataTypes(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)6, sessionReadRequest.getDataSources(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (boolean)sessionReadRequest.zzhhy);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)sessionReadRequest.zzeck);
        zzbfp.zza((Parcel)parcel2, (int)8, (boolean)sessionReadRequest.zzhgq);
        zzbfp.zzb((Parcel)parcel2, (int)9, sessionReadRequest.getExcludedPackages(), (boolean)false);
        SessionReadRequest sessionReadRequest2 = sessionReadRequest;
        zzbfp.zza((Parcel)parcel2, (int)10, (IBinder)(sessionReadRequest2.zzhia == null ? null : sessionReadRequest2.zzhia.asBinder()), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionReadRequest(Builder builder, zzav zzav2) {
        this(builder);
    }

    public static class Builder {
        private String zzhhx;
        private String mSessionId;
        private long zzdvq = 0L;
        private long zzgzz = 0L;
        private List<DataType> zzgzy = new ArrayList<DataType>();
        private List<DataSource> zzhgf = new ArrayList<DataSource>();
        private boolean zzhhy = false;
        private boolean zzhgq = false;
        private List<String> zzhhz = new ArrayList<String>();

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzdvq = timeUnit.toMillis(l);
            this.zzgzz = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.zzhhx = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.mSessionId = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzbq.checkNotNull((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.zzhgf.contains((Object)dataSource)) {
                this.zzhgf.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbq.checkNotNull((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzgzy.contains((Object)dataType)) {
                this.zzgzy.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzhhy = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzbq.checkNotNull((Object)string, (Object)"Attempting to use a null package name");
            if (!this.zzhhz.contains(string)) {
                this.zzhhz.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzhgq = true;
            return this;
        }

        public SessionReadRequest build() {
            zzbq.zzb((this.zzdvq > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzdvq});
            zzbq.zzb((this.zzgzz > 0L && this.zzgzz > this.zzdvq ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzgzz});
            return new SessionReadRequest(this, null);
        }
    }
}

