/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.result.zzc;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataReadResult
extends zzbfm
implements Result {
    private final int zzeck;
    private final List<DataSet> zzhab;
    private final Status mStatus;
    private final List<Bucket> zzhii;
    private int zzhij;
    private final List<DataSource> zzhik;
    private final List<DataType> zzhil;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int n, List<RawDataSet> list, Status status, List<RawBucket> list2, int n2, List<DataSource> list3, List<DataType> list4) {
        this.zzeck = n;
        this.mStatus = status;
        this.zzhij = n2;
        this.zzhik = list3;
        this.zzhil = list4;
        this.zzhab = new ArrayList<DataSet>(list.size());
        for (RawDataSet zzbfm2 : list) {
            this.zzhab.add(new DataSet(zzbfm2, list3));
        }
        this.zzhii = new ArrayList<Bucket>(list2.size());
        for (RawBucket rawBucket : list2) {
            this.zzhii.add(new Bucket(rawBucket, list3));
        }
    }

    private DataReadResult(List<DataSet> list, List<Bucket> list2, Status status) {
        this.zzeck = 5;
        this.zzhab = list;
        this.mStatus = status;
        this.zzhii = list2;
        this.zzhij = 1;
        this.zzhik = new ArrayList<DataSource>();
        this.zzhil = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, List<DataType> list, List<DataSource> list2) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource zzbfm2 : list2) {
            arrayList.add(DataSet.create(zzbfm2));
        }
        for (DataType dataType : list) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzhab) {
            if (!dataType.equals((Object)dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzhab) {
            if (!dataSource.equals((Object)dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zzhab;
    }

    public List<Bucket> getBuckets() {
        return this.zzhii;
    }

    public final int zzaqx() {
        return this.zzhij;
    }

    public final void zzb(DataReadResult dataReadResult) {
        Iterator<zzbfm> iterator = dataReadResult.getDataSets().iterator();
        while (iterator.hasNext()) {
            DataReadResult.zza(iterator.next(), this.zzhab);
        }
        block1: for (Bucket bucket : dataReadResult.getBuckets()) {
            List<Bucket> list = this.zzhii;
            Bucket bucket2 = bucket;
            DataReadResult dataReadResult2 = this;
            for (Bucket bucket3 : list) {
                if (!bucket3.zza(bucket2)) continue;
                Iterator<DataSet> iterator2 = bucket2.getDataSets().iterator();
                while (iterator2.hasNext()) {
                    DataReadResult.zza(iterator2.next(), bucket3.getDataSets());
                }
                continue block1;
            }
            dataReadResult2.zzhii.add(bucket2);
        }
    }

    private static void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals((Object)dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadResult)) break block3;
                DataReadResult dataReadResult = (DataReadResult)((Object)object);
                DataReadResult dataReadResult2 = this;
                if (!(dataReadResult2.mStatus.equals((Object)dataReadResult.mStatus) && zzbg.equal(dataReadResult2.zzhab, dataReadResult.zzhab) && zzbg.equal(dataReadResult2.zzhii, dataReadResult.zzhii))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mStatus, this.zzhab, this.zzhii});
    }

    public String toString() {
        Object object;
        Object object2;
        int n;
        zzbi zzbi2 = zzbg.zzx((Object)((Object)this)).zzg("status", (Object)this.mStatus);
        if (this.zzhab.size() > 5) {
            n = this.zzhab.size();
            object2 = new StringBuilder(21).append(n).append(" data sets").toString();
        } else {
            object2 = this.zzhab;
        }
        zzbi zzbi3 = zzbi2.zzg("dataSets", object2);
        if (this.zzhii.size() > 5) {
            n = this.zzhii.size();
            object = new StringBuilder(19).append(n).append(" buckets").toString();
        } else {
            object = this.zzhii;
        }
        return zzbi3.zzg("buckets", object).toString();
    }

    private List<RawBucket> zzaqy() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzhii.size());
        for (Bucket bucket : this.zzhii) {
            arrayList.add(new RawBucket(bucket, this.zzhik, this.zzhil));
        }
        return arrayList;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadResult dataReadResult = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        DataReadResult dataReadResult2 = dataReadResult;
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(dataReadResult2.zzhab.size());
        for (DataSet dataSet : dataReadResult2.zzhab) {
            arrayList.add(new RawDataSet(dataSet, dataReadResult2.zzhik, dataReadResult2.zzhil));
        }
        zzbfp.zzd((Parcel)parcel2, (int)1, arrayList, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)dataReadResult.getStatus(), (int)n, (boolean)false);
        zzbfp.zzd((Parcel)parcel2, (int)3, dataReadResult.zzaqy(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)5, (int)dataReadResult.zzhij);
        zzbfp.zzc((Parcel)parcel2, (int)6, dataReadResult.zzhik, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)7, dataReadResult.zzhil, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)dataReadResult.zzeck);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

