/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzg;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
extends zzbfm
implements Result {
    private final int zzeck;
    private final List<Subscription> zzhio;
    private final Status mStatus;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzg();

    ListSubscriptionsResult(int n, List<Subscription> list, Status status) {
        this.zzeck = n;
        this.zzhio = list;
        this.mStatus = status;
    }

    private ListSubscriptionsResult(List<Subscription> list, Status status) {
        this.zzeck = 3;
        this.zzhio = Collections.unmodifiableList(list);
        this.mStatus = (Status)zzbq.checkNotNull((Object)status, (Object)"status");
    }

    public static ListSubscriptionsResult zzae(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzhio;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzhio) {
            if (!dataType.equals((Object)subscription.zzaqq())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ListSubscriptionsResult)) break block3;
                ListSubscriptionsResult listSubscriptionsResult = (ListSubscriptionsResult)((Object)object);
                ListSubscriptionsResult listSubscriptionsResult2 = this;
                if (!(listSubscriptionsResult2.mStatus.equals((Object)listSubscriptionsResult.mStatus) && zzbg.equal(listSubscriptionsResult2.zzhio, listSubscriptionsResult.zzhio))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mStatus, this.zzhio});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("status", (Object)this.mStatus).zzg("subscriptions", this.zzhio).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ListSubscriptionsResult listSubscriptionsResult = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, listSubscriptionsResult.getSubscriptions(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)listSubscriptionsResult.getStatus(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)listSubscriptionsResult.zzeck);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

