/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzae;
import com.google.android.gms.fitness.result.zzh;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
extends zzbfm
implements Result {
    private final int zzeck;
    private final List<Session> zzhgg;
    private final List<zzae> zzhip;
    private final Status mStatus;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzh();

    SessionReadResult(int n, List<Session> list, List<zzae> list2, Status status) {
        this.zzeck = n;
        this.zzhgg = list;
        this.zzhip = Collections.unmodifiableList(list2);
        this.mStatus = status;
    }

    private SessionReadResult(List<Session> list, List<zzae> list2, Status status) {
        this.zzeck = 3;
        this.zzhgg = list;
        this.zzhip = Collections.unmodifiableList(list2);
        this.mStatus = status;
    }

    public static SessionReadResult zzaf(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<zzae> arrayList2 = new ArrayList<zzae>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzhgg;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzbq.zzb((boolean)this.zzhgg.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzae zzae2 : this.zzhip) {
            if (!zzbg.equal((Object)((Object)session), (Object)((Object)zzae2.getSession())) || !dataType.equals((Object)zzae2.getDataSet().getDataType())) continue;
            arrayList.add(zzae2.getDataSet());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzbq.zzb((boolean)this.zzhgg.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzae zzae2 : this.zzhip) {
            if (!zzbg.equal((Object)((Object)session), (Object)((Object)zzae2.getSession()))) continue;
            arrayList.add(zzae2.getDataSet());
        }
        return arrayList;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadResult)) break block3;
                SessionReadResult sessionReadResult = (SessionReadResult)((Object)object);
                SessionReadResult sessionReadResult2 = this;
                if (!(sessionReadResult2.mStatus.equals((Object)sessionReadResult.mStatus) && zzbg.equal(sessionReadResult2.zzhgg, sessionReadResult.zzhgg) && zzbg.equal(sessionReadResult2.zzhip, sessionReadResult.zzhip))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mStatus, this.zzhgg, this.zzhip});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("status", (Object)this.mStatus).zzg("sessions", this.zzhgg).zzg("sessionDataSets", this.zzhip).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadResult sessionReadResult = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, sessionReadResult.getSessions(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)2, sessionReadResult.zzhip, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (Parcelable)sessionReadResult.getStatus(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)sessionReadResult.zzeck);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

