/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzfmk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends zzbgl
implements ReflectedParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final long zza;
    private final long zzb;
    private final Session zzc;
    private final int zzd;
    private final List<DataSet> zze;
    private final int zzf;
    private boolean zzg = false;
    @Hide
    public static final Parcelable.Creator<Bucket> CREATOR = new zze();

    @Hide
    Bucket(long l, long l2, Session session, int n, List<DataSet> list, int n2, boolean bl) {
        this.zza = l;
        this.zzb = l2;
        this.zzc = session;
        this.zzd = n;
        this.zze = list;
        this.zzf = n2;
        this.zzg = bl;
    }

    @Hide
    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(rawBucket.zza, rawBucket.zzb, rawBucket.zzc, rawBucket.zzd, Bucket.zza(rawBucket.zze, list), rawBucket.zzf, rawBucket.zzg);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zza, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzb, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzc;
    }

    public String getActivity() {
        return zzfmk.zza(this.zzd);
    }

    @Hide
    public final int zza() {
        return this.zzd;
    }

    public List<DataSet> getDataSets() {
        return this.zze;
    }

    @Nullable
    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zze) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzf;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Bucket)) {
            return false;
        }
        Bucket bucket = (Bucket)((Object)object);
        return this.zza == bucket.zza && this.zzb == bucket.zzb && this.zzd == bucket.zzd && zzbg.zza(this.zze, bucket.zze) && this.zzf == bucket.zzf && this.zzg == bucket.zzg;
    }

    @Hide
    public final boolean zza(Bucket bucket) {
        return this.zza == bucket.zza && this.zzb == bucket.zzb && this.zzd == bucket.zzd && this.zzf == bucket.zzf;
    }

    @Hide
    public final boolean zzb() {
        if (this.zzg) {
            return true;
        }
        Iterator<DataSet> iterator = this.zze.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zza()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzd, this.zzf});
    }

    public String toString() {
        return zzbg.zza((Object)((Object)this)).zza("startTime", (Object)this.zza).zza("endTime", (Object)this.zzb).zza("activity", (Object)this.zzd).zza("dataSets", this.zze).zza("bucketType", (Object)Bucket.zza(this.zzf)).zza("serverHasMoreData", (Object)this.zzg).toString();
    }

    @Hide
    public static String zza(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Bucket bucket = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)bucket.zza);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)bucket.zzb);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)bucket.getSession(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (int)bucket.zzd);
        zzbgo.zzc((Parcel)parcel2, (int)5, bucket.getDataSets(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (int)bucket.getBucketType());
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)bucket.zzb());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

