/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgq;
import com.google.android.gms.internal.zzbwh;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
extends zzbgl
implements ReflectedParcelable {
    private final DataSource zza;
    private long zzb;
    private long zzc;
    private final Value[] zzd;
    private DataSource zze;
    private long zzf;
    private long zzg;
    @Hide
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzh();

    @Hide
    DataPoint(DataSource dataSource, long l, long l2, Value[] valueArray, DataSource dataSource2, long l3, long l4) {
        this.zza = dataSource;
        this.zze = dataSource2;
        this.zzb = l;
        this.zzc = l2;
        this.zzd = valueArray;
        this.zzf = l3;
        this.zzg = l4;
    }

    @Hide
    DataPoint(List<DataSource> list, RawDataPoint rawDataPoint) {
        this(DataPoint.zza(list, rawDataPoint.zzd()), DataPoint.zza(list, rawDataPoint.zze()), rawDataPoint);
    }

    @Hide
    private DataPoint(DataSource dataSource, @Nullable DataSource dataSource2, RawDataPoint rawDataPoint) {
        this(dataSource, DataPoint.zza(rawDataPoint.zza(), 0L), DataPoint.zza(rawDataPoint.zzb(), 0L), rawDataPoint.zzc(), dataSource2, DataPoint.zza(rawDataPoint.zzf(), 0L), DataPoint.zza(rawDataPoint.zzg(), 0L));
    }

    private static DataSource zza(List<DataSource> list, int n) {
        if (n >= 0 && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    private DataPoint(DataSource dataSource) {
        this.zza = (DataSource)((Object)zzbq.zza((Object)((Object)dataSource), (Object)"Data source cannot be null"));
        List<Field> list = dataSource.getDataType().getFields();
        this.zzd = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzd[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    @Nullable
    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzbgq.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public final DataPoint setTimestamp(long l, TimeUnit timeUnit) {
        this.zzb = timeUnit.toNanos(l);
        DataPoint dataPoint = this;
        if (DataType.TYPE_LOCATION_SAMPLE.equals((Object)dataPoint.getDataType()) && timeUnit.convert(1L, TimeUnit.MILLISECONDS) > 1L) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzb = zzbwh.zza(this.zzb, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public final DataPoint setTimeInterval(long l, long l2, TimeUnit timeUnit) {
        this.zzc = timeUnit.toNanos(l);
        this.zzb = timeUnit.toNanos(l2);
        return this;
    }

    @Hide
    public final Value zza(int n) {
        DataType dataType = this.getDataType();
        zzbq.zzb((n >= 0 && n < dataType.getFields().size() ? 1 : 0) != 0, (String)"fieldIndex %s is out of range for %s", (Object[])new Object[]{n, dataType});
        return this.zzd[n];
    }

    public final Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzd[n];
    }

    @Hide
    public final Value[] zza() {
        return this.zzd;
    }

    public final DataPoint setFloatValues(float ... fArray) {
        this.zzb(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.zzd[i].setFloat(fArray[i]);
        }
        return this;
    }

    public final DataPoint setIntValues(int ... nArray) {
        this.zzb(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.zzd[i].setInt(nArray[i]);
        }
        return this;
    }

    private final void zzb(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzbq.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public final DataType getDataType() {
        return this.zza.getDataType();
    }

    public final DataSource getDataSource() {
        return this.zza;
    }

    public final DataSource getOriginalDataSource() {
        if (this.zze != null) {
            return this.zze;
        }
        return this.zza;
    }

    @Hide
    @Nullable
    public final DataSource zzb() {
        return this.zze;
    }

    public final long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzb, TimeUnit.NANOSECONDS);
    }

    @Hide
    public final long zzc() {
        return this.zzf;
    }

    @Hide
    public final long zzd() {
        return this.zzg;
    }

    public final long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzc, TimeUnit.NANOSECONDS);
    }

    public final long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzb, TimeUnit.NANOSECONDS);
    }

    @Hide
    public final void zze() {
        DataSource dataSource = this.getDataSource();
        zzbq.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzbq.zzb((this.zzb > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzbq.zzb((this.zzc <= this.zzb ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataPoint)) {
            return false;
        }
        DataPoint dataPoint = (DataPoint)((Object)object);
        return zzbg.zza((Object)((Object)this.zza), (Object)((Object)dataPoint.zza)) && this.zzb == dataPoint.zzb && this.zzc == dataPoint.zzc && Arrays.equals((Object[])this.zzd, (Object[])dataPoint.zzd) && zzbg.zza((Object)((Object)this.getOriginalDataSource()), (Object)((Object)dataPoint.getOriginalDataSource()));
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc});
    }

    public final String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString((Object[])this.zzd), this.zzc, this.zzb, this.zzf, this.zzg, this.zza.zzb(), this.zze != null ? this.zze.zzb() : "N/A");
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataPoint dataPoint = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)dataPoint.getDataSource(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)dataPoint.zzb);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)dataPoint.zzc);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable[])dataPoint.zzd, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)dataPoint.zze, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (long)dataPoint.zzf);
        zzbgo.zza((Parcel)parcel2, (int)8, (long)dataPoint.zzg);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    private static long zza(@Nullable Long l, long l2) {
        if (l != null) {
            return l;
        }
        return 0L;
    }
}

