/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.zzab;
import com.google.android.gms.fitness.data.zzp;
import com.google.android.gms.fitness.data.zzr;
import com.google.android.gms.fitness.data.zzs;
import com.google.android.gms.fitness.data.zzx;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzfmk;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Goal
extends zzbgl {
    public static final int OBJECTIVE_TYPE_METRIC = 1;
    public static final int OBJECTIVE_TYPE_DURATION = 2;
    public static final int OBJECTIVE_TYPE_FREQUENCY = 3;
    private final long zza;
    private final long zzb;
    private final List<Integer> zzc;
    private final Recurrence zzd;
    private final int zze;
    private final MetricObjective zzf;
    private final DurationObjective zzg;
    private final FrequencyObjective zzh;
    public static final Parcelable.Creator<Goal> CREATOR = new zzs();

    public long getCreateTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zza, TimeUnit.NANOSECONDS);
    }

    public long getStartTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzd != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzd.zzb) {
                case 1: {
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzd.zzb;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zza, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzd != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzd.zzb) {
                case 1: {
                    calendar2.add(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.add(4, 1);
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.add(2, 1);
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzd.zzb;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzb, TimeUnit.NANOSECONDS);
    }

    @Nullable
    public String getActivityName() {
        if (this.zzc.isEmpty() || this.zzc.size() > 1) {
            return null;
        }
        return zzfmk.zza(this.zzc.get(0));
    }

    @Nullable
    public Recurrence getRecurrence() {
        return this.zzd;
    }

    public int getObjectiveType() {
        return this.zze;
    }

    private static String zza(int n) {
        switch (n) {
            case 1: {
                return "metric";
            }
            case 2: {
                return "duration";
            }
            case 3: {
                return "frequency";
            }
            case 0: {
                return "unknown";
            }
        }
        throw new IllegalArgumentException("invalid objective type value");
    }

    public MetricObjective getMetricObjective() {
        this.zzb(1);
        return this.zzf;
    }

    public DurationObjective getDurationObjective() {
        this.zzb(2);
        return this.zzg;
    }

    public FrequencyObjective getFrequencyObjective() {
        this.zzb(3);
        return this.zzh;
    }

    @Hide
    Goal(long l, long l2, List<Integer> list, Recurrence recurrence, int n, MetricObjective metricObjective, DurationObjective durationObjective, FrequencyObjective frequencyObjective) {
        this.zza = l;
        this.zzb = l2;
        this.zzc = list;
        this.zzd = recurrence;
        this.zze = n;
        this.zzf = metricObjective;
        this.zzg = durationObjective;
        this.zzh = frequencyObjective;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Goal)) {
            return false;
        }
        Goal goal = (Goal)((Object)object);
        return this.zza == goal.zza && this.zzb == goal.zzb && zzbg.zza(this.zzc, goal.zzc) && zzbg.zza((Object)((Object)this.zzd), (Object)((Object)goal.zzd)) && this.zze == goal.zze && zzbg.zza((Object)((Object)this.zzf), (Object)((Object)goal.zzf)) && zzbg.zza((Object)((Object)this.zzg), (Object)((Object)goal.zzg)) && zzbg.zza((Object)((Object)this.zzh), (Object)((Object)goal.zzh));
    }

    public int hashCode() {
        return this.zze;
    }

    public String toString() {
        return zzbg.zza((Object)((Object)this)).zza("activity", (Object)this.getActivityName()).zza("recurrence", (Object)this.zzd).zza("metricObjective", (Object)this.zzf).zza("durationObjective", (Object)this.zzg).zza("frequencyObjective", (Object)this.zzh).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Goal goal = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)goal.zza);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)goal.zzb);
        zzbgo.zzd((Parcel)parcel2, (int)3, goal.zzc, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)goal.getRecurrence(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (int)goal.getObjectiveType());
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)goal.zzf, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)goal.zzg, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)goal.zzh, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    private final void zzb(int n) throws MismatchedGoalException {
        if (n != this.zze) {
            throw new MismatchedGoalException(String.format("%s goal does not have %s objective", Goal.zza(this.zze), Goal.zza(n)));
        }
    }

    public static class MismatchedGoalException
    extends IllegalStateException {
        public MismatchedGoalException(String string) {
            super(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ObjectiveType {
    }

    public static class FrequencyObjective
    extends zzbgl {
        private final int zza;
        public static final Parcelable.Creator<FrequencyObjective> CREATOR = new zzr();

        public int getFrequency() {
            return this.zza;
        }

        public FrequencyObjective(int n) {
            this.zza = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof FrequencyObjective)) {
                return false;
            }
            FrequencyObjective frequencyObjective = (FrequencyObjective)((Object)object);
            return this.zza == frequencyObjective.zza;
        }

        public int hashCode() {
            return this.zza;
        }

        public String toString() {
            return zzbg.zza((Object)((Object)this)).zza("frequency", (Object)this.zza).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            FrequencyObjective frequencyObjective = this;
            int n2 = zzbgo.zza((Parcel)parcel2);
            zzbgo.zza((Parcel)parcel2, (int)1, (int)frequencyObjective.getFrequency());
            zzbgo.zza((Parcel)parcel2, (int)n2);
        }
    }

    public static class DurationObjective
    extends zzbgl {
        private final long zza;
        public static final Parcelable.Creator<DurationObjective> CREATOR = new zzp();

        public long getDuration(TimeUnit timeUnit) {
            return timeUnit.convert(this.zza, TimeUnit.NANOSECONDS);
        }

        @Hide
        DurationObjective(long l) {
            this.zza = l;
        }

        public DurationObjective(long l, TimeUnit timeUnit) {
            this(timeUnit.toNanos(l));
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DurationObjective)) {
                return false;
            }
            DurationObjective durationObjective = (DurationObjective)((Object)object);
            return this.zza == durationObjective.zza;
        }

        public int hashCode() {
            return (int)this.zza;
        }

        public String toString() {
            return zzbg.zza((Object)((Object)this)).zza("duration", (Object)this.zza).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            DurationObjective durationObjective = this;
            int n2 = zzbgo.zza((Parcel)parcel2);
            zzbgo.zza((Parcel)parcel2, (int)1, (long)durationObjective.zza);
            zzbgo.zza((Parcel)parcel2, (int)n2);
        }
    }

    public static class MetricObjective
    extends zzbgl {
        private final String zza;
        private final double zzb;
        private final double zzc;
        public static final Parcelable.Creator<MetricObjective> CREATOR = new zzx();

        public String getDataTypeName() {
            return this.zza;
        }

        public double getValue() {
            return this.zzb;
        }

        public MetricObjective(String string, double d, double d2) {
            this.zza = string;
            this.zzb = d;
            this.zzc = d2;
        }

        public MetricObjective(String string, double d) {
            this(string, d, 0.0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MetricObjective)) {
                return false;
            }
            MetricObjective metricObjective = (MetricObjective)((Object)object);
            return zzbg.zza((Object)this.zza, (Object)metricObjective.zza) && this.zzb == metricObjective.zzb && this.zzc == metricObjective.zzc;
        }

        public int hashCode() {
            return this.zza.hashCode();
        }

        public String toString() {
            return zzbg.zza((Object)((Object)this)).zza("dataTypeName", (Object)this.zza).zza("value", (Object)this.zzb).zza("initialValue", (Object)this.zzc).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            MetricObjective metricObjective = this;
            int n2 = zzbgo.zza((Parcel)parcel2);
            zzbgo.zza((Parcel)parcel2, (int)1, (String)metricObjective.getDataTypeName(), (boolean)false);
            zzbgo.zza((Parcel)parcel2, (int)2, (double)metricObjective.getValue());
            zzbgo.zza((Parcel)parcel2, (int)3, (double)metricObjective.zzc);
            zzbgo.zza((Parcel)parcel2, (int)n2);
        }
    }

    public static class Recurrence
    extends zzbgl {
        public static final int UNIT_DAY = 1;
        public static final int UNIT_WEEK = 2;
        public static final int UNIT_MONTH = 3;
        private final int zza;
        private final int zzb;
        public static final Parcelable.Creator<Recurrence> CREATOR = new zzab();

        public int getCount() {
            return this.zza;
        }

        public int getUnit() {
            return this.zzb;
        }

        public Recurrence(int n, int n2) {
            this.zza = n;
            zzbq.zza((n2 > 0 && n2 <= 3 ? 1 : 0) != 0);
            this.zzb = n2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Recurrence)) {
                return false;
            }
            Recurrence recurrence = (Recurrence)((Object)object);
            return this.zza == recurrence.zza && this.zzb == recurrence.zzb;
        }

        public int hashCode() {
            return this.zzb;
        }

        public String toString() {
            String string;
            zzbi zzbi2 = zzbg.zza((Object)((Object)this)).zza("count", (Object)this.zza);
            switch (this.zzb) {
                case 1: {
                    string = "day";
                    break;
                }
                case 2: {
                    string = "week";
                    break;
                }
                case 3: {
                    string = "month";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid unit value");
                }
            }
            return zzbi2.zza("unit", (Object)string).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Recurrence recurrence = this;
            int n2 = zzbgo.zza((Parcel)parcel2);
            zzbgo.zza((Parcel)parcel2, (int)1, (int)recurrence.getCount());
            zzbgo.zza((Parcel)parcel2, (int)2, (int)recurrence.getUnit());
            zzbgo.zza((Parcel)parcel2, (int)n2);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RecurrenceUnit {
        }
    }
}

