/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzai;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzfmk;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
extends zzbgl {
    private final int zza;
    private boolean zzb;
    private float zzc;
    private String zzd;
    private Map<String, MapValue> zze;
    private int[] zzf;
    private float[] zzg;
    private byte[] zzh;
    @Hide
    public static final Parcelable.Creator<Value> CREATOR = new zzai();

    @Hide
    public Value(int n) {
        this(n, false, 0.0f, null, null, null, null, null);
    }

    @Hide
    Value(int n, boolean bl, float f, String string, Bundle bundle, int[] nArray, float[] fArray, byte[] byArray) {
        ArrayMap arrayMap;
        this.zza = n;
        this.zzb = bl;
        this.zzc = f;
        this.zzd = string;
        Bundle bundle2 = bundle;
        if (bundle2 == null) {
            arrayMap = null;
        } else {
            bundle2.setClassLoader(MapValue.class.getClassLoader());
            ArrayMap arrayMap2 = new ArrayMap(bundle2.size());
            for (String string2 : bundle2.keySet()) {
                arrayMap2.put(string2, (MapValue)bundle2.getParcelable(string2));
            }
            arrayMap = arrayMap2;
        }
        this.zze = arrayMap;
        this.zzf = nArray;
        this.zzg = fArray;
        this.zzh = byArray;
    }

    public final void setInt(int n) {
        zzbq.zza((this.zza == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzb = true;
        this.zzc = Float.intBitsToFloat(n);
    }

    public final void setFloat(float f) {
        zzbq.zza((this.zza == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzb = true;
        this.zzc = f;
    }

    public final void setString(String string) {
        zzbq.zza((this.zza == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzb = true;
        this.zzd = string;
    }

    public final void setKeyValue(String string, float f) {
        zzbq.zza((this.zza == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzb = true;
        if (this.zze == null) {
            this.zze = new HashMap<String, MapValue>();
        }
        this.zze.put(string, new MapValue(2, f));
    }

    public final void clearKey(String string) {
        zzbq.zza((this.zza == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zze != null) {
            this.zze.remove(string);
        }
    }

    public final void setActivity(String string) {
        this.setInt(zzfmk.zza(string));
    }

    public final boolean isSet() {
        return this.zzb;
    }

    public final int getFormat() {
        return this.zza;
    }

    public final int asInt() {
        zzbq.zza((this.zza == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.zzc);
    }

    public final float asFloat() {
        zzbq.zza((this.zza == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.zzc;
    }

    public final String asString() {
        zzbq.zza((this.zza == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzd;
    }

    @Nullable
    public final Float getKeyValue(String string) {
        zzbq.zza((this.zza == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zze != null && this.zze.containsKey(string)) {
            return Float.valueOf(this.zze.get(string).zza());
        }
        return null;
    }

    public final String asActivity() {
        return zzfmk.zza(this.asInt());
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)((Object)object);
        if (this.zza == value.zza && this.zzb == value.zzb) {
            switch (this.zza) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.zzc == value.zzc;
                }
                case 3: {
                    return zzbg.zza((Object)this.zzd, (Object)value.zzd);
                }
                case 4: {
                    return zzbg.zza(this.zze, value.zze);
                }
                case 5: {
                    return Arrays.equals(this.zzf, value.zzf);
                }
                case 6: {
                    return Arrays.equals(this.zzg, value.zzg);
                }
                case 7: {
                    return Arrays.equals(this.zzh, value.zzh);
                }
            }
            return this.zzc == value.zzc;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.zzc), this.zzd, this.zze, this.zzf, this.zzg, this.zzh});
    }

    public final String toString() {
        if (!this.zzb) {
            return "unset";
        }
        switch (this.zza) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.zzc);
            }
            case 3: {
                return this.zzd;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zze).toString();
            }
            case 5: {
                return Arrays.toString(this.zzf);
            }
            case 6: {
                return Arrays.toString(this.zzg);
            }
            case 7: {
                return zzn.zza((byte[])this.zzh, (int)0, (int)this.zzh.length, (boolean)false);
            }
        }
        return "unknown";
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Bundle bundle;
        Parcel parcel2 = parcel;
        Value value = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (int)value.getFormat());
        zzbgo.zza((Parcel)parcel2, (int)2, (boolean)value.isSet());
        zzbgo.zza((Parcel)parcel2, (int)3, (float)value.zzc);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)value.zzd, (boolean)false);
        Value value2 = value;
        if (value2.zze == null) {
            bundle = null;
        } else {
            Bundle bundle2 = new Bundle(value2.zze.size());
            for (Map.Entry<String, MapValue> entry : value2.zze.entrySet()) {
                bundle2.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
            }
            bundle = bundle2;
        }
        zzbgo.zza((Parcel)parcel2, (int)5, bundle, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (int[])value.zzf, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (float[])value.zzg, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (byte[])value.zzh, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

