/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.result.zzc;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataReadResult
extends zzbgl
implements Result {
    private final List<DataSet> zza;
    private final Status zzb;
    private final List<Bucket> zzc;
    private int zzd;
    private final List<DataSource> zze;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(List<RawDataSet> list, Status status, List<RawBucket> list2, int n, List<DataSource> list3) {
        this.zzb = status;
        this.zzd = n;
        this.zze = list3;
        this.zza = new ArrayList<DataSet>(list.size());
        for (RawDataSet zzbgl2 : list) {
            this.zza.add(new DataSet(zzbgl2, list3));
        }
        this.zzc = new ArrayList<Bucket>(list2.size());
        for (RawBucket rawBucket : list2) {
            this.zzc.add(new Bucket(rawBucket, list3));
        }
    }

    @Hide
    private DataReadResult(List<DataSet> list, List<Bucket> list2, Status status) {
        this.zza = list;
        this.zzb = status;
        this.zzc = list2;
        this.zzd = 1;
        this.zze = new ArrayList<DataSource>();
    }

    @Hide
    public static DataReadResult zza(Status status, List<DataType> list, List<DataSource> list2) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource zzbgl2 : list2) {
            arrayList.add(DataSet.create(zzbgl2));
        }
        for (DataType dataType : list) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zza) {
            if (!dataType.equals((Object)dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zza) {
            if (!dataSource.equals((Object)dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zza;
    }

    public List<Bucket> getBuckets() {
        return this.zzc;
    }

    @Hide
    public final int zza() {
        return this.zzd;
    }

    @Hide
    public final void zza(DataReadResult dataReadResult) {
        Iterator<zzbgl> iterator = dataReadResult.getDataSets().iterator();
        while (iterator.hasNext()) {
            DataReadResult.zza(iterator.next(), this.zza);
        }
        block1: for (Bucket bucket : dataReadResult.getBuckets()) {
            List<Bucket> list = this.zzc;
            Bucket bucket2 = bucket;
            DataReadResult dataReadResult2 = this;
            for (Bucket bucket3 : list) {
                if (!bucket3.zza(bucket2)) continue;
                Iterator<DataSet> iterator2 = bucket2.getDataSets().iterator();
                while (iterator2.hasNext()) {
                    DataReadResult.zza(iterator2.next(), bucket3.getDataSets());
                }
                continue block1;
            }
            dataReadResult2.zzc.add(bucket2);
        }
    }

    private static void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals((Object)dataSet.getDataSource())) continue;
            dataSet2.zza((Iterable<DataPoint>)dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    public Status getStatus() {
        return this.zzb;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadResult)) break block3;
                DataReadResult dataReadResult = (DataReadResult)((Object)object);
                DataReadResult dataReadResult2 = this;
                if (!(dataReadResult2.zzb.equals((Object)dataReadResult.zzb) && zzbg.zza(dataReadResult2.zza, dataReadResult.zza) && zzbg.zza(dataReadResult2.zzc, dataReadResult.zzc))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzb, this.zza, this.zzc});
    }

    public String toString() {
        Object object;
        Object object2;
        int n;
        zzbi zzbi2 = zzbg.zza((Object)((Object)this)).zza("status", (Object)this.zzb);
        if (this.zza.size() > 5) {
            n = this.zza.size();
            object2 = new StringBuilder(21).append(n).append(" data sets").toString();
        } else {
            object2 = this.zza;
        }
        zzbi zzbi3 = zzbi2.zza("dataSets", object2);
        if (this.zzc.size() > 5) {
            n = this.zzc.size();
            object = new StringBuilder(19).append(n).append(" buckets").toString();
        } else {
            object = this.zzc;
        }
        return zzbi3.zza("buckets", object).toString();
    }

    @Hide
    private List<RawBucket> zzb() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzc.size());
        for (Bucket bucket : this.zzc) {
            arrayList.add(new RawBucket(bucket, this.zze));
        }
        return arrayList;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadResult dataReadResult = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        DataReadResult dataReadResult2 = dataReadResult;
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(dataReadResult2.zza.size());
        for (DataSet dataSet : dataReadResult2.zza) {
            arrayList.add(new RawDataSet(dataSet, dataReadResult2.zze));
        }
        zzbgo.zzd((Parcel)parcel2, (int)1, arrayList, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)dataReadResult.getStatus(), (int)n, (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)3, dataReadResult.zzb(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (int)dataReadResult.zzd);
        zzbgo.zzc((Parcel)parcel2, (int)6, dataReadResult.zze, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

