/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.zzf;
import com.google.android.gms.fitness.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FitnessOptions
implements GoogleSignInOptionsExtension,
Api.ApiOptions.HasGoogleSignInAccountOptions {
    public static final int ACCESS_READ = 0;
    public static final int ACCESS_WRITE = 1;
    private final Map<Integer, List<DataType>> zzhhf;
    private final Set<Scope> zzhhg;
    private final GoogleSignInAccount zzhhh;

    private FitnessOptions(Map<Integer, List<DataType>> map, GoogleSignInAccount googleSignInAccount) {
        this.zzhhf = map;
        this.zzhhh = googleSignInAccount;
        ArrayList<Scope> arrayList = new ArrayList<Scope>();
        for (Map.Entry<Integer, List<DataType>> entry : map.entrySet()) {
            for (DataType dataType : entry.getValue()) {
                if (entry.getKey() == 0 && dataType.zzarw() != null) {
                    arrayList.add(new Scope(dataType.zzarw()));
                    continue;
                }
                if (entry.getKey() != 1 || dataType.zzarx() == null) continue;
                arrayList.add(new Scope(dataType.zzarx()));
            }
        }
        this.zzhhg = zzg.zzi(arrayList);
    }

    @Hide
    public GoogleSignInAccount getGoogleSignInAccount() {
        return this.zzhhh;
    }

    public int getExtensionType() {
        return 3;
    }

    public Bundle toBundle() {
        return new Bundle();
    }

    @Nullable
    public List<Scope> getImpliedScopes() {
        return new ArrayList<Scope>(this.zzhhg);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    @Hide
    public static Builder zzb(GoogleSignInAccount googleSignInAccount) {
        if (googleSignInAccount != null) {
            return new Builder(null).zzc(googleSignInAccount);
        }
        return new Builder(null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FitnessOptions fitnessOptions = (FitnessOptions)object;
        return zzbg.equal(this.zzhhf, fitnessOptions.zzhhf) && zzbg.equal((Object)this.zzhhh, (Object)fitnessOptions.zzhhh);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhf, this.zzhhh});
    }

    /* synthetic */ FitnessOptions(Map map, GoogleSignInAccount googleSignInAccount, zzf zzf2) {
        this(map, googleSignInAccount);
    }

    public static final class Builder {
        private final Map<Integer, List<DataType>> map = new HashMap<Integer, List<DataType>>();
        private GoogleSignInAccount zzhhh;

        private Builder() {
        }

        public final Builder addDataType(@NonNull DataType dataType) {
            return this.addDataType(dataType, 0);
        }

        public final Builder addDataType(@NonNull DataType dataType, int n) {
            zzbq.checkArgument((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"valid access types are FitnessOptions.ACCESS_READ or FitnessOptions.ACCESS_WRITE");
            List<DataType> list = this.map.get(n);
            if (list == null) {
                list = new ArrayList<DataType>();
                this.map.put(n, list);
            }
            list.add(dataType);
            return this;
        }

        @Hide
        private final Builder zzc(@NonNull GoogleSignInAccount googleSignInAccount) {
            this.zzhhh = googleSignInAccount;
            return this;
        }

        public final FitnessOptions build() {
            return new FitnessOptions(this.map, this.zzhhh, null);
        }

        /* synthetic */ Builder(zzf zzf2) {
            this();
        }
    }
}

