/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgq;
import com.google.android.gms.internal.zzbwh;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
extends zzbgl
implements ReflectedParcelable {
    private final DataSource zzhhk;
    private long zzhig;
    private long zzhih;
    private final Value[] zzhii;
    private DataSource zzhij;
    private long zzhik;
    private long zzhil;
    @Hide
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzh();

    @Hide
    DataPoint(DataSource dataSource, long l, long l2, Value[] valueArray, DataSource dataSource2, long l3, long l4) {
        this.zzhhk = dataSource;
        this.zzhij = dataSource2;
        this.zzhig = l;
        this.zzhih = l2;
        this.zzhii = valueArray;
        this.zzhik = l3;
        this.zzhil = l4;
    }

    @Hide
    DataPoint(List<DataSource> list, RawDataPoint rawDataPoint) {
        this(DataPoint.zzc(list, rawDataPoint.zzasa()), DataPoint.zzc(list, rawDataPoint.zzasb()), rawDataPoint);
    }

    @Hide
    private DataPoint(DataSource dataSource, @Nullable DataSource dataSource2, RawDataPoint rawDataPoint) {
        this(dataSource, DataPoint.zza(rawDataPoint.getTimestampNanos(), 0L), DataPoint.zza(rawDataPoint.zzarz(), 0L), rawDataPoint.zzaro(), dataSource2, DataPoint.zza(rawDataPoint.zzarq(), 0L), DataPoint.zza(rawDataPoint.zzarr(), 0L));
    }

    private static DataSource zzc(List<DataSource> list, int n) {
        if (n >= 0 && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    private DataPoint(DataSource dataSource) {
        this.zzhhk = (DataSource)((Object)zzbq.checkNotNull((Object)((Object)dataSource), (Object)"Data source cannot be null"));
        List<Field> list = dataSource.getDataType().getFields();
        this.zzhii = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzhii[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    @Nullable
    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzbgq.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public final DataPoint setTimestamp(long l, TimeUnit timeUnit) {
        this.zzhig = timeUnit.toNanos(l);
        DataPoint dataPoint = this;
        if (DataType.TYPE_LOCATION_SAMPLE.equals((Object)dataPoint.getDataType()) && timeUnit.convert(1L, TimeUnit.MILLISECONDS) > 1L) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzhig = zzbwh.zza(this.zzhig, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public final DataPoint setTimeInterval(long l, long l2, TimeUnit timeUnit) {
        this.zzhih = timeUnit.toNanos(l);
        this.zzhig = timeUnit.toNanos(l2);
        return this;
    }

    @Hide
    public final Value zzdb(int n) {
        DataType dataType = this.getDataType();
        zzbq.zzb((n >= 0 && n < dataType.getFields().size() ? 1 : 0) != 0, (String)"fieldIndex %s is out of range for %s", (Object[])new Object[]{n, dataType});
        return this.zzhii[n];
    }

    public final Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzhii[n];
    }

    @Hide
    public final Value[] zzaro() {
        return this.zzhii;
    }

    public final DataPoint setFloatValues(float ... fArray) {
        this.zzdc(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.zzhii[i].setFloat(fArray[i]);
        }
        return this;
    }

    public final DataPoint setIntValues(int ... nArray) {
        this.zzdc(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.zzhii[i].setInt(nArray[i]);
        }
        return this;
    }

    private final void zzdc(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzbq.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public final DataType getDataType() {
        return this.zzhhk.getDataType();
    }

    public final DataSource getDataSource() {
        return this.zzhhk;
    }

    public final DataSource getOriginalDataSource() {
        if (this.zzhij != null) {
            return this.zzhij;
        }
        return this.zzhhk;
    }

    @Hide
    @Nullable
    public final DataSource zzarp() {
        return this.zzhij;
    }

    public final long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhig, TimeUnit.NANOSECONDS);
    }

    @Hide
    public final long zzarq() {
        return this.zzhik;
    }

    @Hide
    public final long zzarr() {
        return this.zzhil;
    }

    public final long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhih, TimeUnit.NANOSECONDS);
    }

    public final long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhig, TimeUnit.NANOSECONDS);
    }

    @Hide
    public final void zzars() {
        DataSource dataSource = this.getDataSource();
        zzbq.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzbq.zzb((this.zzhig > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzbq.zzb((this.zzhih <= this.zzhig ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataPoint)) {
            return false;
        }
        DataPoint dataPoint = (DataPoint)((Object)object);
        return zzbg.equal((Object)((Object)this.zzhhk), (Object)((Object)dataPoint.zzhhk)) && this.zzhig == dataPoint.zzhig && this.zzhih == dataPoint.zzhih && Arrays.equals((Object[])this.zzhii, (Object[])dataPoint.zzhii) && zzbg.equal((Object)((Object)this.getOriginalDataSource()), (Object)((Object)dataPoint.getOriginalDataSource()));
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhk, this.zzhig, this.zzhih});
    }

    public final String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString((Object[])this.zzhii), this.zzhih, this.zzhig, this.zzhik, this.zzhil, this.zzhhk.toDebugString(), this.zzhij != null ? this.zzhij.toDebugString() : "N/A");
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataPoint dataPoint = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)dataPoint.getDataSource(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)dataPoint.zzhig);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)dataPoint.zzhih);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable[])dataPoint.zzhii, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)dataPoint.zzhij, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (long)dataPoint.zzhik);
        zzbgo.zza((Parcel)parcel2, (int)8, (long)dataPoint.zzhil);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    private static long zza(@Nullable Long l, long l2) {
        if (l != null) {
            return l;
        }
        return 0L;
    }
}

