/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzai;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzfmk;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
extends zzbgl {
    private final int format;
    private boolean zzhlt;
    private float value;
    private String zzgim;
    private Map<String, MapValue> zzhlu;
    private int[] zzhlv;
    private float[] zzhlw;
    private byte[] zzhlx;
    @Hide
    public static final Parcelable.Creator<Value> CREATOR = new zzai();

    @Hide
    public Value(int n) {
        this(n, false, 0.0f, null, null, null, null, null);
    }

    @Hide
    Value(int n, boolean bl, float f, String string, Bundle bundle, int[] nArray, float[] fArray, byte[] byArray) {
        ArrayMap arrayMap;
        this.format = n;
        this.zzhlt = bl;
        this.value = f;
        this.zzgim = string;
        Bundle bundle2 = bundle;
        if (bundle2 == null) {
            arrayMap = null;
        } else {
            bundle2.setClassLoader(MapValue.class.getClassLoader());
            ArrayMap arrayMap2 = new ArrayMap(bundle2.size());
            for (String string2 : bundle2.keySet()) {
                arrayMap2.put(string2, (MapValue)bundle2.getParcelable(string2));
            }
            arrayMap = arrayMap2;
        }
        this.zzhlu = arrayMap;
        this.zzhlv = nArray;
        this.zzhlw = fArray;
        this.zzhlx = byArray;
    }

    public final void setInt(int n) {
        zzbq.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzhlt = true;
        this.value = Float.intBitsToFloat(n);
    }

    public final void setFloat(float f) {
        zzbq.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzhlt = true;
        this.value = f;
    }

    public final void setString(String string) {
        zzbq.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzhlt = true;
        this.zzgim = string;
    }

    public final void setKeyValue(String string, float f) {
        zzbq.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzhlt = true;
        if (this.zzhlu == null) {
            this.zzhlu = new HashMap<String, MapValue>();
        }
        this.zzhlu.put(string, new MapValue(2, f));
    }

    public final void clearKey(String string) {
        zzbq.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzhlu != null) {
            this.zzhlu.remove(string);
        }
    }

    public final void setActivity(String string) {
        this.setInt(zzfmk.zzuc(string));
    }

    public final boolean isSet() {
        return this.zzhlt;
    }

    public final int getFormat() {
        return this.format;
    }

    public final int asInt() {
        zzbq.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.value);
    }

    public final float asFloat() {
        zzbq.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.value;
    }

    public final String asString() {
        zzbq.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzgim;
    }

    @Nullable
    public final Float getKeyValue(String string) {
        zzbq.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzhlu != null && this.zzhlu.containsKey(string)) {
            return Float.valueOf(this.zzhlu.get(string).asFloat());
        }
        return null;
    }

    public final String asActivity() {
        return zzfmk.getName(this.asInt());
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)((Object)object);
        if (this.format == value.format && this.zzhlt == value.zzhlt) {
            switch (this.format) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.value == value.value;
                }
                case 3: {
                    return zzbg.equal((Object)this.zzgim, (Object)value.zzgim);
                }
                case 4: {
                    return zzbg.equal(this.zzhlu, value.zzhlu);
                }
                case 5: {
                    return Arrays.equals(this.zzhlv, value.zzhlv);
                }
                case 6: {
                    return Arrays.equals(this.zzhlw, value.zzhlw);
                }
                case 7: {
                    return Arrays.equals(this.zzhlx, value.zzhlx);
                }
            }
            return this.value == value.value;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.value), this.zzgim, this.zzhlu, this.zzhlv, this.zzhlw, this.zzhlx});
    }

    public final String toString() {
        if (!this.zzhlt) {
            return "unset";
        }
        switch (this.format) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.value);
            }
            case 3: {
                return this.zzgim;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzhlu).toString();
            }
            case 5: {
                return Arrays.toString(this.zzhlv);
            }
            case 6: {
                return Arrays.toString(this.zzhlw);
            }
            case 7: {
                return zzn.zza((byte[])this.zzhlx, (int)0, (int)this.zzhlx.length, (boolean)false);
            }
        }
        return "unknown";
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Bundle bundle;
        Parcel parcel2 = parcel;
        Value value = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, (int)value.getFormat());
        zzbgo.zza((Parcel)parcel2, (int)2, (boolean)value.isSet());
        zzbgo.zza((Parcel)parcel2, (int)3, (float)value.value);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)value.zzgim, (boolean)false);
        Value value2 = value;
        if (value2.zzhlu == null) {
            bundle = null;
        } else {
            Bundle bundle2 = new Bundle(value2.zzhlu.size());
            for (Map.Entry<String, MapValue> entry : value2.zzhlu.entrySet()) {
                bundle2.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
            }
            bundle = bundle2;
        }
        zzbgo.zza((Parcel)parcel2, (int)5, bundle, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (int[])value.zzhlv, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (float[])value.zzhlw, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (byte[])value.zzhlx, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

