/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.fitness.request.zzj;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbzt;
import com.google.android.gms.internal.zzbzu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends zzbgl {
    private final long zzhhl;
    private final long zzhhm;
    private final List<DataSource> zzhnx;
    private final List<DataType> zzhhz;
    private final List<Session> zzhny;
    private final boolean zzhnz;
    private final boolean zzhoa;
    @Nullable
    private final zzbzt zzhnu;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzj();

    @Hide
    DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.zzhhl = l;
        this.zzhhm = l2;
        this.zzhnx = Collections.unmodifiableList(list);
        this.zzhhz = Collections.unmodifiableList(list2);
        this.zzhny = list3;
        this.zzhnz = bl;
        this.zzhoa = bl2;
        this.zzhnu = zzbzu.zzba(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzhhl, builder.zzhhm, (List<DataSource>)builder.zzhnx, (List<DataType>)builder.zzhhz, (List<Session>)builder.zzhny, builder.zzhnz, builder.zzhoa, (zzbzt)null);
    }

    @Hide
    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzbzt zzbzt2) {
        this(dataDeleteRequest.zzhhl, dataDeleteRequest.zzhhm, dataDeleteRequest.zzhnx, dataDeleteRequest.zzhhz, dataDeleteRequest.zzhny, dataDeleteRequest.zzhnz, dataDeleteRequest.zzhoa, zzbzt2);
    }

    @Hide
    private DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, @Nullable zzbzt zzbzt2) {
        this.zzhhl = l;
        this.zzhhm = l2;
        this.zzhnx = Collections.unmodifiableList(list);
        this.zzhhz = Collections.unmodifiableList(list2);
        this.zzhny = list3;
        this.zzhnz = bl;
        this.zzhoa = bl2;
        this.zzhnu = zzbzt2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhm, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzhnx;
    }

    public List<DataType> getDataTypes() {
        return this.zzhhz;
    }

    public List<Session> getSessions() {
        return this.zzhny;
    }

    public boolean deleteAllData() {
        return this.zzhnz;
    }

    public boolean deleteAllSessions() {
        return this.zzhoa;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataDeleteRequest)) break block3;
                DataDeleteRequest dataDeleteRequest = (DataDeleteRequest)((Object)object);
                DataDeleteRequest dataDeleteRequest2 = this;
                if (!(dataDeleteRequest2.zzhhl == dataDeleteRequest.zzhhl && dataDeleteRequest2.zzhhm == dataDeleteRequest.zzhhm && zzbg.equal(dataDeleteRequest2.zzhnx, dataDeleteRequest.zzhnx) && zzbg.equal(dataDeleteRequest2.zzhhz, dataDeleteRequest.zzhhz) && zzbg.equal(dataDeleteRequest2.zzhny, dataDeleteRequest.zzhny) && dataDeleteRequest2.zzhnz == dataDeleteRequest.zzhnz && dataDeleteRequest2.zzhoa == dataDeleteRequest.zzhoa)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhl, this.zzhhm});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzhhl).zzg("endTimeMillis", (Object)this.zzhhm).zzg("dataSources", this.zzhnx).zzg("dateTypes", this.zzhhz).zzg("sessions", this.zzhny).zzg("deleteAllData", (Object)this.zzhnz).zzg("deleteAllSessions", (Object)this.zzhoa).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataDeleteRequest dataDeleteRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)dataDeleteRequest.zzhhl);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)dataDeleteRequest.zzhhm);
        zzbgo.zzc((Parcel)parcel2, (int)3, dataDeleteRequest.getDataSources(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, dataDeleteRequest.getDataTypes(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, dataDeleteRequest.getSessions(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (boolean)dataDeleteRequest.deleteAllData());
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)dataDeleteRequest.deleteAllSessions());
        DataDeleteRequest dataDeleteRequest2 = dataDeleteRequest;
        zzbgo.zza((Parcel)parcel2, (int)8, (IBinder)(dataDeleteRequest2.zzhnu == null ? null : dataDeleteRequest2.zzhnu.asBinder()), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataDeleteRequest(Builder builder, zzi zzi2) {
        this(builder);
    }

    public static class Builder {
        private long zzhhl;
        private long zzhhm;
        private List<DataSource> zzhnx = new ArrayList<DataSource>();
        private List<DataType> zzhhz = new ArrayList<DataType>();
        private List<Session> zzhny = new ArrayList<Session>();
        private boolean zzhnz = false;
        private boolean zzhoa = false;

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbq.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbq.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzhhl = timeUnit.toMillis(l);
            this.zzhhm = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzbq.checkArgument((boolean)this.zzhhz.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzbq.checkArgument((boolean)this.zzhnx.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzhnz = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzbq.checkArgument((!this.zzhnz ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzbq.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzhhz.contains((Object)dataType)) {
                this.zzhhz.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzbq.checkArgument((!this.zzhnz ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzbq.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzhnx.contains((Object)dataSource)) {
                this.zzhnx.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzbq.checkArgument((!this.zzhoa ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzbq.checkArgument((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzbq.checkArgument((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzhny.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzbq.checkArgument((boolean)this.zzhny.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzhoa = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzbq.zza((this.zzhhl > 0L && this.zzhhm > this.zzhhl ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzhnz || !this.zzhnx.isEmpty() || !this.zzhhz.isEmpty();
            boolean bl2 = this.zzhoa || !this.zzhny.isEmpty();
            zzbq.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            Builder builder = this;
            if (!builder.zzhny.isEmpty()) {
                for (Session session : builder.zzhny) {
                    zzbq.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= builder.zzhhl && session.getEndTime(TimeUnit.MILLISECONDS) <= builder.zzhhm ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, builder.zzhhl, builder.zzhhm});
                }
            }
            return new DataDeleteRequest(this, null);
        }
    }
}

