/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.fitness.request.zzn;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbyk;
import com.google.android.gms.internal.zzbyl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends zzbgl {
    public static final int NO_LIMIT = 0;
    private final List<DataType> zzhhz;
    private final List<DataSource> zzhnx;
    private final long zzhhl;
    private final long zzhhm;
    private final List<DataType> zzhoc;
    private final List<DataSource> zzhod;
    private final int zzhic;
    private final long zzhoe;
    private final DataSource zzhof;
    private final int limit;
    private final boolean zzhog;
    private final boolean zzhoh;
    @Nullable
    private final zzbyk zzhoi;
    private final List<Device> zzhoj;
    private final List<Integer> zzhok;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzn();

    @Hide
    DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5, List<Integer> list6) {
        this.zzhhz = list;
        this.zzhnx = list2;
        this.zzhhl = l;
        this.zzhhm = l2;
        this.zzhoc = list3;
        this.zzhod = list4;
        this.zzhic = n;
        this.zzhoe = l3;
        this.zzhof = dataSource;
        this.limit = n2;
        this.zzhog = bl;
        this.zzhoh = bl2;
        this.zzhoi = iBinder == null ? null : zzbyl.zzat(iBinder);
        this.zzhoj = list5 == null ? Collections.emptyList() : list5;
        this.zzhok = list6 == null ? Collections.emptyList() : list6;
    }

    private DataReadRequest(Builder builder) {
        this((List<DataType>)builder.zzhhz, (List<DataSource>)builder.zzhnx, builder.zzhhl, builder.zzhhm, (List<DataType>)builder.zzhoc, (List<DataSource>)builder.zzhod, builder.zzhic, builder.zzhoe, builder.zzhof, builder.limit, false, builder.zzhoh, (zzbyk)null, (List<Device>)builder.zzhoj, (List<Integer>)builder.zzhok);
    }

    @Hide
    public DataReadRequest(DataReadRequest dataReadRequest, zzbyk zzbyk2) {
        this(dataReadRequest.zzhhz, dataReadRequest.zzhnx, dataReadRequest.zzhhl, dataReadRequest.zzhhm, dataReadRequest.zzhoc, dataReadRequest.zzhod, dataReadRequest.zzhic, dataReadRequest.zzhoe, dataReadRequest.zzhof, dataReadRequest.limit, dataReadRequest.zzhog, dataReadRequest.zzhoh, zzbyk2, dataReadRequest.zzhoj, dataReadRequest.zzhok);
    }

    @Hide
    private DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, @Nullable zzbyk zzbyk2, List<Device> list5, List<Integer> list6) {
        this(list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zzbyk2 == null ? null : zzbyk2.asBinder(), list5, list6);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhm, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzhhz;
    }

    public List<DataSource> getDataSources() {
        return this.zzhnx;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzhoc;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzhod;
    }

    public int getBucketType() {
        return this.zzhic;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhoe, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public DataSource getActivityDataSource() {
        return this.zzhof;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadRequest)) break block3;
                DataReadRequest dataReadRequest = (DataReadRequest)((Object)object);
                DataReadRequest dataReadRequest2 = this;
                if (!(dataReadRequest2.zzhhz.equals(dataReadRequest.zzhhz) && dataReadRequest2.zzhnx.equals(dataReadRequest.zzhnx) && dataReadRequest2.zzhhl == dataReadRequest.zzhhl && dataReadRequest2.zzhhm == dataReadRequest.zzhhm && dataReadRequest2.zzhic == dataReadRequest.zzhic && dataReadRequest2.zzhod.equals(dataReadRequest.zzhod) && dataReadRequest2.zzhoc.equals(dataReadRequest.zzhoc) && zzbg.equal((Object)((Object)dataReadRequest2.zzhof), (Object)((Object)dataReadRequest.zzhof)) && dataReadRequest2.zzhoe == dataReadRequest.zzhoe && dataReadRequest2.zzhoh == dataReadRequest.zzhoh && dataReadRequest2.limit == dataReadRequest.limit && dataReadRequest2.zzhog == dataReadRequest.zzhog && zzbg.equal((Object)dataReadRequest2.zzhoi, (Object)dataReadRequest.zzhoi) && zzbg.equal(dataReadRequest2.zzhoj, dataReadRequest.zzhoj) && zzbg.equal(dataReadRequest2.zzhok, dataReadRequest.zzhok))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhic, this.zzhhl, this.zzhhm});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzhhz.isEmpty()) {
            for (DataType zzbgl2 : this.zzhhz) {
                stringBuilder.append(zzbgl2.zzary()).append(" ");
            }
        }
        if (!this.zzhnx.isEmpty()) {
            for (DataSource dataSource : this.zzhnx) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzhic != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzda(this.zzhic));
            if (this.zzhoe > 0L) {
                stringBuilder.append(" >").append(this.zzhoe).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzhoc.isEmpty()) {
            for (DataType dataType : this.zzhoc) {
                stringBuilder.append(dataType.zzary()).append(" ");
            }
        }
        if (!this.zzhod.isEmpty()) {
            for (DataSource dataSource : this.zzhod) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzhhl, this.zzhhl, this.zzhhm, this.zzhhm));
        if (this.zzhof != null) {
            stringBuilder.append("activities: ").append(this.zzhof.toDebugString());
        }
        if (!this.zzhok.isEmpty()) {
            stringBuilder.append("quality: ");
            Iterator<Object> iterator = this.zzhok.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stringBuilder.append(DataSource.zzdd(n)).append(" ");
            }
        }
        if (this.zzhoh) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public List<Integer> getFilteredDataQualityStandards() {
        return this.zzhok;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadRequest dataReadRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, dataReadRequest.getDataTypes(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)2, dataReadRequest.getDataSources(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)dataReadRequest.zzhhl);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)dataReadRequest.zzhhm);
        zzbgo.zzc((Parcel)parcel2, (int)5, dataReadRequest.getAggregatedDataTypes(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, dataReadRequest.getAggregatedDataSources(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)7, (int)dataReadRequest.getBucketType());
        zzbgo.zza((Parcel)parcel2, (int)8, (long)dataReadRequest.zzhoe);
        zzbgo.zza((Parcel)parcel2, (int)9, (Parcelable)dataReadRequest.getActivityDataSource(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)10, (int)dataReadRequest.getLimit());
        zzbgo.zza((Parcel)parcel2, (int)12, (boolean)dataReadRequest.zzhog);
        zzbgo.zza((Parcel)parcel2, (int)13, (boolean)dataReadRequest.zzhoh);
        DataReadRequest dataReadRequest2 = dataReadRequest;
        zzbgo.zza((Parcel)parcel2, (int)14, (IBinder)(dataReadRequest2.zzhoi == null ? null : dataReadRequest2.zzhoi.asBinder()), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)16, dataReadRequest.zzhoj, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)17, dataReadRequest.getFilteredDataQualityStandards(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataReadRequest(Builder builder, zzm zzm2) {
        this(builder);
    }

    public static class Builder {
        private List<DataType> zzhhz = new ArrayList<DataType>();
        private List<DataSource> zzhnx = new ArrayList<DataSource>();
        private List<DataType> zzhoc = new ArrayList<DataType>();
        private List<DataSource> zzhod = new ArrayList<DataSource>();
        private DataSource zzhof;
        private long zzhhl;
        private long zzhhm;
        private int zzhic = 0;
        private long zzhoe = 0L;
        private int limit = 0;
        private boolean zzhog = false;
        private boolean zzhoh = false;
        private final List<Device> zzhoj = new ArrayList<Device>();
        private final List<Integer> zzhok = new ArrayList<Integer>();

        public Builder() {
        }

        public Builder read(DataSource dataSource) {
            zzbq.checkNotNull((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbq.checkArgument((!this.zzhod.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzhnx.contains((Object)dataSource)) {
                this.zzhnx.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbq.checkNotNull((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbq.zza((!this.zzhoc.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzhhz.contains((Object)dataType)) {
                this.zzhhz.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzbq.checkNotNull((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbq.zza((!this.zzhnx.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            List<DataType> list = DataType.getAggregatesForInput(dataType2);
            zzbq.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzbq.zzb((boolean)list.contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.zzhod.contains((Object)dataSource)) {
                this.zzhod.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzbq.checkNotNull((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbq.zza((!this.zzhhz.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            List<DataType> list = DataType.getAggregatesForInput(dataType);
            zzbq.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzbq.zzb((boolean)list.contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.zzhoc.contains((Object)dataType)) {
                this.zzhoc.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzhic == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhic});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzhic = 1;
            this.zzhoe = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzhic == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhic});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzhic = 3;
            this.zzhoe = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbq.zzb((this.zzhic == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhic});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbq.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbq.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzhof = dataSource;
            this.zzhic = 3;
            this.zzhoe = timeUnit.toMillis(n);
            return this;
        }

        public Builder addFilteredDataQualityStandard(int n) {
            zzbq.checkArgument((boolean)this.zzhoj.isEmpty(), (Object)"Cannot add data quality standard filter when filtering by device.");
            this.zzhok.add(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzhic == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhic});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzhic = 4;
            this.zzhoe = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbq.zzb((this.zzhic == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhic});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbq.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbq.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzhof = dataSource;
            this.zzhic = 4;
            this.zzhoe = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzhic == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzhic});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzhic = 2;
            this.zzhoe = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.zzhhl = timeUnit.toMillis(l);
            this.zzhhm = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzhoh = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.limit = n;
            return this;
        }

        public DataReadRequest build() {
            zzbq.zza((!this.zzhnx.isEmpty() || !this.zzhhz.isEmpty() || !this.zzhod.isEmpty() || !this.zzhoc.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzbq.zza((this.zzhhl > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzhhl});
            zzbq.zza((this.zzhhm > 0L && this.zzhhm > this.zzhhl ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzhhm});
            boolean bl = this.zzhod.isEmpty() && this.zzhoc.isEmpty();
            zzbq.zza((bl && this.zzhic == 0 || !bl && this.zzhic != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this, null);
        }
    }
}

