/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzy;
import com.google.android.gms.fitness.request.zzz;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbzt;
import com.google.android.gms.internal.zzbzu;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends zzbgl {
    private final long zzhhl;
    private final long zzhhm;
    private final DataSet zzhlq;
    @Nullable
    private final zzbzt zzhnu;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzz();

    @Hide
    public DataUpdateRequest(long l, long l2, DataSet dataSet, @Nullable IBinder iBinder) {
        this.zzhhl = l;
        this.zzhhm = l2;
        this.zzhlq = dataSet;
        this.zzhnu = zzbzu.zzba(iBinder);
    }

    @Hide
    private DataUpdateRequest(Builder builder) {
        this(builder.zzhhl, builder.zzhhm, builder.zzhlq, null);
    }

    @Hide
    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zzhhl, dataUpdateRequest.zzhhm, dataUpdateRequest.getDataSet(), iBinder);
    }

    @Hide
    public final long zzabi() {
        return this.zzhhl;
    }

    @Hide
    public final long zzasg() {
        return this.zzhhm;
    }

    public DataSet getDataSet() {
        return this.zzhlq;
    }

    public IBinder getCallbackBinder() {
        if (this.zzhnu == null) {
            return null;
        }
        return this.zzhnu.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhm, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataUpdateRequest)) break block3;
                DataUpdateRequest dataUpdateRequest = (DataUpdateRequest)((Object)object);
                DataUpdateRequest dataUpdateRequest2 = this;
                if (!(dataUpdateRequest2.zzhhl == dataUpdateRequest.zzhhl && dataUpdateRequest2.zzhhm == dataUpdateRequest.zzhhm && zzbg.equal((Object)((Object)dataUpdateRequest2.zzhlq), (Object)((Object)dataUpdateRequest.zzhlq)))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhl, this.zzhhm, this.zzhlq});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzhhl).zzg("endTimeMillis", (Object)this.zzhhm).zzg("dataSet", (Object)this.zzhlq).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataUpdateRequest dataUpdateRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)dataUpdateRequest.zzhhl);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)dataUpdateRequest.zzhhm);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)dataUpdateRequest.getDataSet(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (IBinder)dataUpdateRequest.getCallbackBinder(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataUpdateRequest(Builder builder, zzy zzy2) {
        this(builder);
    }

    public static class Builder {
        private long zzhhl;
        private long zzhhm;
        private DataSet zzhlq;

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbq.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbq.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzhhl = timeUnit.toMillis(l);
            this.zzhhm = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzbq.checkNotNull((Object)((Object)dataSet), (Object)"Must set the data set");
            this.zzhlq = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            Builder builder = this;
            zzbq.zza((long)builder.zzhhl, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzbq.zza((long)builder.zzhhm, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzbq.checkNotNull((Object)((Object)builder.zzhlq), (Object)"Must set the data set");
            for (DataPoint dataPoint : builder.zzhlq.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                zzbq.zza((!(l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < builder.zzhhl || l2 != 0L && l2 > builder.zzhhm || l > builder.zzhhm || l < builder.zzhhl) ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, builder.zzhhl, builder.zzhhm});
            }
            return new DataUpdateRequest(this, null);
        }
    }
}

