/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzaq;
import com.google.android.gms.location.LocationRequest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzhhk;
    private final DataType zzhhj;
    private final long zzhlr;
    private final long zzhpb;
    private final long zzhpa;
    private final int zzhls;
    private final long zzhpf;

    private SensorRequest(Builder builder) {
        this.zzhhk = builder.zzhhk;
        this.zzhhj = builder.zzhhj;
        this.zzhlr = builder.zzhlr;
        this.zzhpb = builder.zzhpb;
        this.zzhpa = builder.zzhpa;
        this.zzhls = builder.zzhls;
        this.zzhpf = builder.zzhpf;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        int n;
        this.zzhlr = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzhpb = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzhpa = this.zzhlr;
        this.zzhhj = dataSource.getDataType();
        switch (locationRequest.getPriority()) {
            case 100: {
                n = 3;
                break;
            }
            case 104: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        this.zzhls = n;
        this.zzhhk = dataSource;
        long l = locationRequest.getExpirationTime();
        if (l == Long.MAX_VALUE) {
            this.zzhpf = Long.MAX_VALUE;
            return;
        }
        this.zzhpf = TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    @Nullable
    public DataSource getDataSource() {
        return this.zzhhk;
    }

    public DataType getDataType() {
        return this.zzhhj;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhlr, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhpb, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhpa, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzhls;
    }

    @Hide
    public final long zzasi() {
        return this.zzhpf;
    }

    public String toString() {
        return zzbg.zzx((Object)this).zzg("dataSource", (Object)this.zzhhk).zzg("dataType", (Object)this.zzhhj).zzg("samplingRateMicros", (Object)this.zzhlr).zzg("deliveryLatencyMicros", (Object)this.zzhpa).zzg("timeOutMicros", (Object)this.zzhpf).toString();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SensorRequest)) break block3;
                SensorRequest sensorRequest = (SensorRequest)object;
                SensorRequest sensorRequest2 = this;
                if (!(zzbg.equal((Object)((Object)sensorRequest2.zzhhk), (Object)((Object)sensorRequest.zzhhk)) && zzbg.equal((Object)((Object)sensorRequest2.zzhhj), (Object)((Object)sensorRequest.zzhhj)) && sensorRequest2.zzhlr == sensorRequest.zzhlr && sensorRequest2.zzhpb == sensorRequest.zzhpb && sensorRequest2.zzhpa == sensorRequest.zzhpa && sensorRequest2.zzhls == sensorRequest.zzhls && sensorRequest2.zzhpf == sensorRequest.zzhpf)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhk, this.zzhhj, this.zzhlr, this.zzhpb, this.zzhpa, this.zzhls, this.zzhpf});
    }

    /* synthetic */ SensorRequest(Builder builder, zzaq zzaq2) {
        this(builder);
    }

    public static class Builder {
        private DataSource zzhhk;
        private DataType zzhhj;
        private long zzhlr = -1L;
        private long zzhpb = 0L;
        private long zzhpa = 0L;
        private boolean zzhpg = false;
        private int zzhls = 2;
        private long zzhpf = Long.MAX_VALUE;

        public Builder() {
        }

        public Builder setDataSource(DataSource dataSource) {
            this.zzhhk = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzhhj = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzbq.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzhlr = timeUnit.toMicros(l);
            if (!this.zzhpg) {
                this.zzhpb = this.zzhlr / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzbq.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzhpg = true;
            this.zzhpb = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzbq.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzhpa = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            int n2;
            switch (n) {
                case 1: 
                case 3: {
                    n2 = n;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            this.zzhls = n2;
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzbq.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzbq.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzhpf = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzbq.zza((this.zzhhk != null || this.zzhhj != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzbq.zza((this.zzhhj == null || this.zzhhk == null || this.zzhhj.equals((Object)this.zzhhk.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this, null);
        }
    }
}

