/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzav;
import com.google.android.gms.fitness.request.zzaw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbzn;
import com.google.android.gms.internal.zzbzo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends zzbgl {
    private final String zzhpj;
    private final String zzcrz;
    private final long zzhhl;
    private final long zzhhm;
    private final List<DataType> zzhhz;
    private final List<DataSource> zzhnx;
    private boolean zzhpk;
    private final boolean zzhoh;
    private final List<String> zzhpl;
    @Nullable
    private final zzbzn zzhpm;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzaw();

    @Hide
    SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.zzhpj = string;
        this.zzcrz = string2;
        this.zzhhl = l;
        this.zzhhm = l2;
        this.zzhhz = list;
        this.zzhnx = list2;
        this.zzhpk = bl;
        this.zzhoh = bl2;
        this.zzhpl = list3;
        this.zzhpm = zzbzo.zzay(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzhpj, builder.zzcrz, builder.zzhhl, builder.zzhhm, (List<DataType>)builder.zzhhz, (List<DataSource>)builder.zzhnx, builder.zzhpn, builder.zzhoh, (List<String>)builder.zzhpl, (zzbzn)null);
    }

    @Hide
    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzbzn zzbzn2) {
        this(sessionReadRequest.zzhpj, sessionReadRequest.zzcrz, sessionReadRequest.zzhhl, sessionReadRequest.zzhhm, sessionReadRequest.zzhhz, sessionReadRequest.zzhnx, sessionReadRequest.zzhpk, sessionReadRequest.zzhoh, sessionReadRequest.zzhpl, zzbzn2);
    }

    @Hide
    private SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, @Nullable zzbzn zzbzn2) {
        this(string, string2, l, l2, list, list2, bl, bl2, list3, zzbzn2 == null ? null : zzbzn2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhm, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public String getSessionName() {
        return this.zzhpj;
    }

    @Nullable
    public String getSessionId() {
        return this.zzcrz;
    }

    public List<DataType> getDataTypes() {
        return this.zzhhz;
    }

    public List<DataSource> getDataSources() {
        return this.zzhnx;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzhpk;
    }

    public List<String> getExcludedPackages() {
        return this.zzhpl;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadRequest)) break block3;
                SessionReadRequest sessionReadRequest = (SessionReadRequest)((Object)object);
                SessionReadRequest sessionReadRequest2 = this;
                if (!(zzbg.equal((Object)sessionReadRequest2.zzhpj, (Object)sessionReadRequest.zzhpj) && sessionReadRequest2.zzcrz.equals(sessionReadRequest.zzcrz) && sessionReadRequest2.zzhhl == sessionReadRequest.zzhhl && sessionReadRequest2.zzhhm == sessionReadRequest.zzhhm && zzbg.equal(sessionReadRequest2.zzhhz, sessionReadRequest.zzhhz) && zzbg.equal(sessionReadRequest2.zzhnx, sessionReadRequest.zzhnx) && sessionReadRequest2.zzhpk == sessionReadRequest.zzhpk && sessionReadRequest2.zzhpl.equals(sessionReadRequest.zzhpl) && sessionReadRequest2.zzhoh == sessionReadRequest.zzhoh)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhpj, this.zzcrz, this.zzhhl, this.zzhhm});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("sessionName", (Object)this.zzhpj).zzg("sessionId", (Object)this.zzcrz).zzg("startTimeMillis", (Object)this.zzhhl).zzg("endTimeMillis", (Object)this.zzhhm).zzg("dataTypes", this.zzhhz).zzg("dataSources", this.zzhnx).zzg("sessionsFromAllApps", (Object)this.zzhpk).zzg("excludedPackages", this.zzhpl).zzg("useServer", (Object)this.zzhoh).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadRequest sessionReadRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)sessionReadRequest.getSessionName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)sessionReadRequest.getSessionId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)sessionReadRequest.zzhhl);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)sessionReadRequest.zzhhm);
        zzbgo.zzc((Parcel)parcel2, (int)5, sessionReadRequest.getDataTypes(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, sessionReadRequest.getDataSources(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)sessionReadRequest.includeSessionsFromAllApps());
        zzbgo.zza((Parcel)parcel2, (int)8, (boolean)sessionReadRequest.zzhoh);
        zzbgo.zzb((Parcel)parcel2, (int)9, sessionReadRequest.getExcludedPackages(), (boolean)false);
        SessionReadRequest sessionReadRequest2 = sessionReadRequest;
        zzbgo.zza((Parcel)parcel2, (int)10, (IBinder)(sessionReadRequest2.zzhpm == null ? null : sessionReadRequest2.zzhpm.asBinder()), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionReadRequest(Builder builder, zzav zzav2) {
        this(builder);
    }

    public static class Builder {
        private String zzhpj;
        private String zzcrz;
        private long zzhhl = 0L;
        private long zzhhm = 0L;
        private List<DataType> zzhhz = new ArrayList<DataType>();
        private List<DataSource> zzhnx = new ArrayList<DataSource>();
        private boolean zzhpn = false;
        private boolean zzhoh = false;
        private List<String> zzhpl = new ArrayList<String>();

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzhhl = timeUnit.toMillis(l);
            this.zzhhm = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.zzhpj = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.zzcrz = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzbq.checkNotNull((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.zzhnx.contains((Object)dataSource)) {
                this.zzhnx.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbq.checkNotNull((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzhhz.contains((Object)dataType)) {
                this.zzhhz.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzhpn = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzbq.checkNotNull((Object)string, (Object)"Attempting to use a null package name");
            if (!this.zzhpl.contains(string)) {
                this.zzhpl.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzhoh = true;
            return this;
        }

        public SessionReadRequest build() {
            zzbq.zzb((this.zzhhl > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzhhl});
            zzbq.zzb((this.zzhhm > 0L && this.zzhhm > this.zzhhl ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzhhm});
            return new SessionReadRequest(this, null);
        }
    }
}

