/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzbyn;
import com.google.android.gms.internal.zzbzt;
import com.google.android.gms.internal.zzcby;
import com.google.android.gms.internal.zzcca;
import com.google.android.gms.internal.zzccd;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzhqa;

    public FitnessSensorService() {
    }

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzhqa = new zza(this, null);
    }

    @CallSuper
    @Nullable
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                String string = String.valueOf(intent);
                String string2 = ((Object)((Object)this)).getClass().getName();
                Log.d((String)"FitnessSensorService", (String)new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Intent ").append(string).append(" received by ").append(string2).toString());
            }
            return this.zzhqa.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    @Hide
    @TargetApi(value=19)
    protected final void zzasl() throws SecurityException {
        int n = Binder.getCallingUid();
        if (zzs.zzanv()) {
            ((AppOpsManager)this.getSystemService("appops")).checkPackage(n, "com.google.android.gms");
            return;
        }
        String[] stringArray = this.getPackageManager().getPackagesForUid(n);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!stringArray2[i].equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    @Hide
    static final class zza
    extends zzccd {
        private final FitnessSensorService zzhqb;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzhqb = fitnessSensorService;
        }

        @Override
        public final void zza(zzcby zzcby2, zzbyn zzbyn2) throws RemoteException {
            this.zzhqb.zzasl();
            List<DataSource> list = this.zzhqb.onFindDataSources(zzcby2.getDataTypes());
            zzbyn2.zza(new DataSourcesResult(list, Status.zzftq));
        }

        @Override
        public final void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzbzt zzbzt2) throws RemoteException {
            this.zzhqb.zzasl();
            if (this.zzhqb.onRegister(fitnessSensorServiceRequest)) {
                zzbzt2.zzn(Status.zzftq);
                return;
            }
            zzbzt2.zzn(new Status(13));
        }

        @Override
        public final void zza(zzcca zzcca2, zzbzt zzbzt2) throws RemoteException {
            this.zzhqb.zzasl();
            if (this.zzhqb.onUnregister(zzcca2.getDataSource())) {
                zzbzt2.zzn(Status.zzftq);
                return;
            }
            zzbzt2.zzn(new Status(13));
        }

        /* synthetic */ zza(FitnessSensorService fitnessSensorService, com.google.android.gms.fitness.service.zza zza2) {
            this(fitnessSensorService);
        }
    }
}

