/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int zzzH;
    private final long zzGX;
    private final long zzacE;
    private final Session zzacG;
    private final int zzacP;
    private final List<DataSet> zzacQ;
    private final int zzacR;
    private boolean zzacS = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zzc();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activityType, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.zzzH = versionCode;
        this.zzGX = startTimeMillis;
        this.zzacE = endTimeMillis;
        this.zzacG = session;
        this.zzacP = activityType;
        this.zzacQ = dataSets;
        this.zzacR = bucketType;
        this.zzacS = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources) {
        this(2, bucket.zzGX, bucket.zzacE, bucket.zzacG, bucket.zzadB, Bucket.zza(bucket.zzacQ, uniqueDataSources), bucket.zzacR, bucket.zzacS);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzGX, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzacE, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzacG;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzacP);
    }

    public int zzoB() {
        return this.zzacP;
    }

    public List<DataSet> getDataSets() {
        return this.zzacQ;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzacQ) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzacR;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Bucket && this.zza((Bucket)o);
    }

    private boolean zza(Bucket bucket) {
        return this.zzGX == bucket.zzGX && this.zzacE == bucket.zzacE && this.zzacP == bucket.zzacP && zzu.equal(this.zzacQ, bucket.zzacQ) && this.zzacR == bucket.zzacR && this.zzacS == bucket.zzacS;
    }

    public boolean zzb(Bucket bucket) {
        return this.zzGX == bucket.zzGX && this.zzacE == bucket.zzacE && this.zzacP == bucket.zzacP && this.zzacR == bucket.zzacR;
    }

    public boolean zzoC() {
        if (this.zzacS) {
            return true;
        }
        for (DataSet dataSet : this.zzacQ) {
            if (!dataSet.zzoC()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzGX, this.zzacE, this.zzacP, this.zzacR});
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("startTime", (Object)this.zzGX).zzg("endTime", (Object)this.zzacE).zzg("activity", (Object)this.zzacP).zzg("dataSets", this.zzacQ).zzg("bucketType", (Object)Bucket.zzdx(this.zzacR)).zzg("serverHasMoreData", (Object)this.zzacS).toString();
    }

    public static String zzdx(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public long zzjm() {
        return this.zzGX;
    }

    public long zzoD() {
        return this.zzacE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

