/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
implements SafeParcelable {
    private final int zzzH;
    private final DataSource zzacD;
    private final DataType zzacC;
    private final List<DataPoint> zzacZ;
    private final List<DataSource> zzada;
    private boolean zzacS = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zze();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.zzzH = versionCode;
        this.zzacD = dataSource;
        this.zzacC = dataSource.getDataType();
        this.zzacS = serverHasMoreData;
        this.zzacZ = new ArrayList<DataPoint>(dataPoints.size());
        this.zzada = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.zzacZ.add(new DataPoint(this.zzada, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.zzzH = 3;
        this.zzacD = (DataSource)zzv.zzr((Object)dataSource);
        this.zzacC = dataSource.getDataType();
        this.zzacZ = new ArrayList<DataPoint>();
        this.zzada = new ArrayList<DataSource>();
        this.zzada.add(this.zzacD);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources) {
        this.zzzH = 3;
        this.zzacD = DataSet.zzb(uniqueDataSources, dataSet.zzadC);
        this.zzacC = this.zzacD.getDataType();
        this.zzada = uniqueDataSources;
        this.zzacS = dataSet.zzacS;
        List<RawDataPoint> list = dataSet.zzadF;
        this.zzacZ = new ArrayList<DataPoint>(list.size());
        for (RawDataPoint rawDataPoint : list) {
            this.zzacZ.add(new DataPoint(this.zzada, rawDataPoint));
        }
    }

    private static <T> T zzb(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzv.zzb((Object)dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzacD);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzv.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzacD.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzacD});
        dataPoint.zzoI();
        this.zzb(dataPoint);
    }

    public void zzb(DataPoint dataPoint) {
        this.zzacZ.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzada.contains(dataSource)) {
            this.zzada.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzb(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzacD;
    }

    public DataType getDataType() {
        return this.zzacD.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzacZ);
    }

    public boolean isEmpty() {
        return this.zzacZ.isEmpty();
    }

    public boolean zzoC() {
        return this.zzacS;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataSet && this.zza((DataSet)o);
    }

    private boolean zza(DataSet dataSet) {
        return zzu.equal((Object)this.getDataType(), (Object)dataSet.getDataType()) && zzu.equal((Object)this.zzacD, (Object)dataSet.zzacD) && zzu.equal(this.zzacZ, dataSet.zzacZ) && this.zzacS == dataSet.zzacS;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzacD});
    }

    public String toString() {
        List<RawDataPoint> list = this.zzoK();
        return String.format("DataSet{%s %s}", this.zzacD.toDebugString(), this.zzacZ.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzacZ.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.zzzH;
    }

    List<RawDataPoint> zzoK() {
        return this.zzl(this.zzada);
    }

    List<RawDataPoint> zzl(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzacZ.size());
        for (DataPoint dataPoint : this.zzacZ) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzoL() {
        return this.zzada;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zze.zza(this, parcel, flags);
    }
}

