/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzn;
import com.google.android.gms.fitness.data.zzs;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawDataPoint
implements SafeParcelable {
    final int zzzH;
    public final long zzacT;
    public final long zzacU;
    public final Value[] zzacV;
    public final int zzadC;
    public final int zzadD;
    public final long zzacX;
    public final long zzacY;
    public static final Parcelable.Creator<RawDataPoint> CREATOR = new zzn();

    public RawDataPoint(int versionCode, long timestampNanos, long startTimeNanos, Value[] values, int dataSourceIndex, int originalDataSourceIndex, long rawTimestamp, long insertionTimeMillis) {
        this.zzzH = versionCode;
        this.zzacT = timestampNanos;
        this.zzacU = startTimeNanos;
        this.zzadC = dataSourceIndex;
        this.zzadD = originalDataSourceIndex;
        this.zzacX = rawTimestamp;
        this.zzacY = insertionTimeMillis;
        this.zzacV = values;
    }

    RawDataPoint(DataPoint dataPoint, List<DataSource> dataSources) {
        this.zzzH = 4;
        this.zzacT = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
        this.zzacU = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
        this.zzacV = dataPoint.zzoF();
        this.zzadC = zzs.zza(dataPoint.getDataSource(), dataSources);
        this.zzadD = zzs.zza(dataPoint.getOriginalDataSource(), dataSources);
        this.zzacX = dataPoint.zzoG();
        this.zzacY = dataPoint.zzoH();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawDataPoint && this.zza((RawDataPoint)o);
    }

    private boolean zza(RawDataPoint rawDataPoint) {
        return this.zzacT == rawDataPoint.zzacT && this.zzacU == rawDataPoint.zzacU && Arrays.equals(this.zzacV, rawDataPoint.zzacV) && this.zzadC == rawDataPoint.zzadC && this.zzadD == rawDataPoint.zzadD && this.zzacX == rawDataPoint.zzacX;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzacT, this.zzacU});
    }

    public String toString() {
        return String.format("RawDataPoint{%s@[%s, %s](%d,%d)}", Arrays.toString(this.zzacV), this.zzacU, this.zzacT, this.zzadC, this.zzadD);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzn.zza(this, parcel, flags);
    }
}

