/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zzjm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int zzzH;
    private final long zzGX;
    private final long zzacE;
    private final List<DataSource> zzaeJ;
    private final List<DataType> zzacO;
    private final List<Session> zzaeK;
    private final boolean zzaeL;
    private final boolean zzaeM;
    private final zzjm zzaeH;
    private final String zzJd;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzd();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, IBinder callback, String packageName) {
        this.zzzH = versionCode;
        this.zzGX = startTimeMillis;
        this.zzacE = endTimeMillis;
        this.zzaeJ = Collections.unmodifiableList(dataSources);
        this.zzacO = Collections.unmodifiableList(dataTypes);
        this.zzaeK = sessions;
        this.zzaeL = deleteAllData;
        this.zzaeM = deleteAllSessions;
        this.zzaeH = callback == null ? null : zzjm.zza.zzaS(callback);
        this.zzJd = packageName;
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzGX, builder.zzacE, builder.zzaeJ, builder.zzacO, builder.zzaeK, builder.zzaeL, builder.zzaeM, null, null);
    }

    public DataDeleteRequest(DataDeleteRequest request, zzjm callback, String packageName) {
        this(request.zzGX, request.zzacE, request.zzaeJ, request.zzacO, request.zzaeK, request.zzaeL, request.zzaeM, callback, packageName);
    }

    public DataDeleteRequest(long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, zzjm callback, String packageName) {
        this.zzzH = 2;
        this.zzGX = startTimeMillis;
        this.zzacE = endTimeMillis;
        this.zzaeJ = Collections.unmodifiableList(dataSources);
        this.zzacO = Collections.unmodifiableList(dataTypes);
        this.zzaeK = sessions;
        this.zzaeL = deleteAllData;
        this.zzaeM = deleteAllSessions;
        this.zzaeH = callback;
        this.zzJd = packageName;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzGX, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzacE, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzaeJ;
    }

    public List<DataType> getDataTypes() {
        return this.zzacO;
    }

    public List<Session> getSessions() {
        return this.zzaeK;
    }

    public boolean deleteAllData() {
        return this.zzaeL;
    }

    public boolean deleteAllSessions() {
        return this.zzaeM;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)o);
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzGX == dataDeleteRequest.zzGX && this.zzacE == dataDeleteRequest.zzacE && zzu.equal(this.zzaeJ, dataDeleteRequest.zzaeJ) && zzu.equal(this.zzacO, dataDeleteRequest.zzacO) && zzu.equal(this.zzaeK, dataDeleteRequest.zzaeK) && this.zzaeL == dataDeleteRequest.zzaeL && this.zzaeM == dataDeleteRequest.zzaeM;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzGX, this.zzacE});
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("startTimeMillis", (Object)this.zzGX).zzg("endTimeMillis", (Object)this.zzacE).zzg("dataSources", this.zzaeJ).zzg("dateTypes", this.zzacO).zzg("sessions", this.zzaeK).zzg("deleteAllData", (Object)this.zzaeL).zzg("deleteAllSessions", (Object)this.zzaeM).toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public boolean zzpg() {
        return this.zzaeL;
    }

    public boolean zzph() {
        return this.zzaeM;
    }

    public long zzoD() {
        return this.zzacE;
    }

    public long zzjm() {
        return this.zzGX;
    }

    public IBinder zzpf() {
        return this.zzaeH == null ? null : this.zzaeH.asBinder();
    }

    public String getPackageName() {
        return this.zzJd;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzd.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzGX;
        private long zzacE;
        private List<DataSource> zzaeJ = new ArrayList<DataSource>();
        private List<DataType> zzacO = new ArrayList<DataType>();
        private List<Session> zzaeK = new ArrayList<Session>();
        private boolean zzaeL = false;
        private boolean zzaeM = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            zzv.zzb((startTime > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{startTime});
            zzv.zzb((endTime > startTime ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{endTime});
            this.zzGX = timeUnit.toMillis(startTime);
            this.zzacE = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            zzv.zzb((this.zzacO.isEmpty() && this.zzaeJ.isEmpty() ? 1 : 0) != 0, (String)"Specific data source/type already specified for deletion. DataSources: %s DataTypes: %s", (Object[])new Object[]{this.zzaeJ, this.zzacO});
            this.zzaeL = true;
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzv.zzb((!this.zzaeL ? 1 : 0) != 0, (Object)"All data is already marked for deletion");
            zzv.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzaeJ.contains(dataSource)) {
                this.zzaeJ.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzv.zzb((!this.zzaeM ? 1 : 0) != 0, (Object)"All sessions already marked for deletion");
            zzv.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzv.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzaeK.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzv.zzb((boolean)this.zzaeK.isEmpty(), (String)"Specific sessions already added for deletion: %s", (Object[])new Object[]{this.zzaeK});
            this.zzaeM = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzv.zzb((!this.zzaeL ? 1 : 0) != 0, (Object)"All data is already marked for deletion");
            zzv.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzacO.contains(dataType)) {
                this.zzacO.add(dataType);
            }
            return this;
        }

        public DataDeleteRequest build() {
            zzv.zza((this.zzGX > 0L && this.zzacE > this.zzGX ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzaeL || !this.zzaeJ.isEmpty() || !this.zzacO.isEmpty();
            boolean bl2 = this.zzaeM || !this.zzaeK.isEmpty();
            zzv.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzpi();
            return new DataDeleteRequest(this);
        }

        private void zzpi() {
            if (this.zzaeK.isEmpty()) {
                return;
            }
            for (Session session : this.zzaeK) {
                zzv.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzGX && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzacE ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.zzGX, this.zzacE});
            }
        }
    }
}

