/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zzix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int zzzH;
    private final List<DataType> zzacO;
    private final List<DataSource> zzaeJ;
    private final long zzGX;
    private final long zzacE;
    private final List<DataType> zzaeO;
    private final List<DataSource> zzaeP;
    private final int zzacR;
    private final long zzaeQ;
    private final DataSource zzaeR;
    private final int zzaeS;
    private final boolean zzaeT;
    private final boolean zzaeU;
    private final zzix zzaeV;
    private final String zzJd;
    private final List<Device> zzaeW;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzf();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, IBinder callback, String packageName, List<Device> filteredDevices) {
        this.zzzH = versionCode;
        this.zzacO = Collections.unmodifiableList(dataTypes);
        this.zzaeJ = Collections.unmodifiableList(dataSources);
        this.zzGX = startTimeMillis;
        this.zzacE = endTimeMillis;
        this.zzaeO = Collections.unmodifiableList(aggregatedDataTypes);
        this.zzaeP = Collections.unmodifiableList(aggregatedDataSources);
        this.zzacR = bucketType;
        this.zzaeQ = bucketDurationMillis;
        this.zzaeR = activityDataSource;
        this.zzaeS = limit;
        this.zzaeT = flushBeforeRead;
        this.zzaeU = serverQueriesEnabled;
        this.zzaeV = callback == null ? null : zzix.zza.zzaD(callback);
        this.zzJd = packageName;
        this.zzaeW = filteredDevices == null ? Collections.EMPTY_LIST : filteredDevices;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzacO, builder.zzaeJ, builder.zzGX, builder.zzacE, builder.zzaeO, builder.zzaeP, builder.zzacR, builder.zzaeQ, builder.zzaeR, builder.zzaeS, builder.zzaeT, builder.zzaeU, null, null, builder.zzaeW);
    }

    public DataReadRequest(DataReadRequest request, zzix callback, String packageName) {
        this(request.zzacO, request.zzaeJ, request.zzGX, request.zzacE, request.zzaeO, request.zzaeP, request.zzacR, request.zzaeQ, request.zzaeR, request.zzaeS, request.zzaeT, request.zzaeU, callback, packageName, request.zzaeW);
    }

    public DataReadRequest(List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, zzix callback, String packageName, List<Device> filteredDevices) {
        this.zzzH = 4;
        this.zzacO = Collections.unmodifiableList(dataTypes);
        this.zzaeJ = Collections.unmodifiableList(dataSources);
        this.zzGX = startTimeMillis;
        this.zzacE = endTimeMillis;
        this.zzaeO = Collections.unmodifiableList(aggregatedDataTypes);
        this.zzaeP = Collections.unmodifiableList(aggregatedDataSources);
        this.zzacR = bucketType;
        this.zzaeQ = bucketDurationMillis;
        this.zzaeR = activityDataSource;
        this.zzaeS = limit;
        this.zzaeT = flushBeforeRead;
        this.zzaeU = serverQueriesEnabled;
        this.zzaeV = callback;
        this.zzJd = packageName;
        this.zzaeW = filteredDevices;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzGX, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzacE, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzacO;
    }

    public List<DataSource> getDataSources() {
        return this.zzaeJ;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzaeO;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzaeP;
    }

    public int getBucketType() {
        return this.zzacR;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaeQ, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzaeR;
    }

    public int getLimit() {
        return this.zzaeS;
    }

    public boolean zzpk() {
        return this.zzaeU;
    }

    public boolean zzpl() {
        return this.zzaeT;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.zzb((DataReadRequest)that);
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzacO.equals(dataReadRequest.zzacO) && this.zzaeJ.equals(dataReadRequest.zzaeJ) && this.zzGX == dataReadRequest.zzGX && this.zzacE == dataReadRequest.zzacE && this.zzacR == dataReadRequest.zzacR && this.zzaeP.equals(dataReadRequest.zzaeP) && this.zzaeO.equals(dataReadRequest.zzaeO) && zzu.equal((Object)this.zzaeR, (Object)dataReadRequest.zzaeR) && this.zzaeQ == dataReadRequest.zzaeQ && this.zzaeU == dataReadRequest.zzaeU;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzacR, this.zzGX, this.zzacE});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzacO.isEmpty()) {
            for (DataType object : this.zzacO) {
                stringBuilder.append(object.zzoO()).append(" ");
            }
        }
        if (!this.zzaeJ.isEmpty()) {
            for (DataSource dataSource : this.zzaeJ) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzacR != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzdx(this.zzacR));
            if (this.zzaeQ > 0L) {
                stringBuilder.append(" >").append(this.zzaeQ).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzaeO.isEmpty()) {
            for (DataType dataType : this.zzaeO) {
                stringBuilder.append(dataType.zzoO()).append(" ");
            }
        }
        if (!this.zzaeP.isEmpty()) {
            for (DataSource dataSource : this.zzaeP) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzGX, this.zzGX, this.zzacE, this.zzacE));
        if (this.zzaeR != null) {
            stringBuilder.append("activities: ").append(this.zzaeR.toDebugString());
        }
        if (this.zzaeU) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public long zzoD() {
        return this.zzacE;
    }

    public long zzjm() {
        return this.zzGX;
    }

    public long zzpm() {
        return this.zzaeQ;
    }

    public IBinder zzpf() {
        return this.zzaeV == null ? null : this.zzaeV.asBinder();
    }

    public String getPackageName() {
        return this.zzJd;
    }

    public List<Device> zzpn() {
        return this.zzaeW;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> zzacO = new ArrayList<DataType>();
        private List<DataSource> zzaeJ = new ArrayList<DataSource>();
        private List<DataType> zzaeO = new ArrayList<DataType>();
        private List<DataSource> zzaeP = new ArrayList<DataSource>();
        private DataSource zzaeR;
        private long zzGX;
        private long zzacE;
        private int zzacR = 0;
        private long zzaeQ = 0L;
        private int zzaeS = 0;
        private boolean zzaeT = false;
        private boolean zzaeU = false;
        private List<Device> zzaeW = new ArrayList<Device>();

        public Builder read(DataSource dataSource) {
            zzv.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzv.zzb((!this.zzaeP.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzaeJ.contains(dataSource)) {
                this.zzaeJ.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzv.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            zzv.zza((!this.zzaeO.contains(dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzacO.contains(dataType)) {
                this.zzacO.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            zzv.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzv.zza((!this.zzaeJ.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            zzv.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzv.zzb((boolean)DataType.getAggregatesForInput(dataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, outputDataType});
            if (!this.zzaeP.contains(dataSource)) {
                this.zzaeP.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            zzv.zzb((Object)inputDataType, (Object)"Attempting to use a null data type");
            zzv.zza((!this.zzacO.contains(inputDataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            zzv.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{inputDataType});
            zzv.zzb((boolean)DataType.getAggregatesForInput(inputDataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{inputDataType, outputDataType});
            if (!this.zzaeO.contains(inputDataType)) {
                this.zzaeO.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            zzv.zzb((this.zzacR == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzacR});
            zzv.zzb((duration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{duration});
            this.zzacR = 1;
            this.zzaeQ = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            zzv.zzb((this.zzacR == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzacR});
            zzv.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzacR = 3;
            this.zzaeQ = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzv.zzb((this.zzacR == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzacR});
            zzv.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzv.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzv.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzaeR = activityDataSource;
            this.zzacR = 3;
            this.zzaeQ = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            zzv.zzb((this.zzacR == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzacR});
            zzv.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzacR = 4;
            this.zzaeQ = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzv.zzb((this.zzacR == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzacR});
            zzv.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzv.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzv.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzaeR = activityDataSource;
            this.zzacR = 4;
            this.zzaeQ = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            zzv.zzb((this.zzacR == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzacR});
            zzv.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzacR = 2;
            this.zzaeQ = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.zzGX = timeUnit.toMillis(start);
            this.zzacE = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaeU = true;
            return this;
        }

        public Builder setLimit(int limit) {
            zzv.zzb((limit > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{limit});
            this.zzaeS = limit;
            return this;
        }

        public DataReadRequest build() {
            zzv.zza((!this.zzaeJ.isEmpty() || !this.zzacO.isEmpty() || !this.zzaeP.isEmpty() || !this.zzaeO.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzv.zza((this.zzGX > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzGX});
            zzv.zza((this.zzacE > 0L && this.zzacE > this.zzGX ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzacE});
            boolean bl = this.zzaeP.isEmpty() && this.zzaeO.isEmpty();
            zzv.zza((bl && this.zzacR == 0 || !bl && this.zzacR != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

