/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzacD;
    private final DataType zzacC;
    private final long zzadK;
    private final long zzafp;
    private final long zzafo;
    private final int zzadL;
    private final LocationRequest zzaft;
    private final long zzafu;

    private SensorRequest(Builder builder) {
        this.zzacD = builder.zzacD;
        this.zzacC = builder.zzacC;
        this.zzadK = builder.zzadK;
        this.zzafp = builder.zzafp;
        this.zzafo = builder.zzafo;
        this.zzadL = builder.zzadL;
        this.zzaft = null;
        this.zzafu = builder.zzafu;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzaft = locationRequest;
        this.zzadK = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzafp = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzafo = this.zzadK;
        this.zzacC = dataSource.getDataType();
        this.zzadL = SensorRequest.zza(locationRequest);
        this.zzacD = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzafu = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzacD;
    }

    public DataType getDataType() {
        return this.zzacC;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzadK, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzafp, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzafo, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzadL;
    }

    public long zzpx() {
        return this.zzafu;
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("dataSource", (Object)this.zzacD).zzg("dataType", (Object)this.zzacC).zzg("samplingRateMicros", (Object)this.zzadK).zzg("deliveryLatencyMicros", (Object)this.zzafo).zzg("timeOutMicros", (Object)this.zzafu).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.zza((SensorRequest)that);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzu.equal((Object)this.zzacD, (Object)sensorRequest.zzacD) && zzu.equal((Object)this.zzacC, (Object)sensorRequest.zzacC) && this.zzadK == sensorRequest.zzadK && this.zzafp == sensorRequest.zzafp && this.zzafo == sensorRequest.zzafo && this.zzadL == sensorRequest.zzadL && zzu.equal((Object)this.zzaft, (Object)sensorRequest.zzaft) && this.zzafu == sensorRequest.zzafu;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzacD, this.zzacC, this.zzadK, this.zzafp, this.zzafo, this.zzadL, this.zzaft, this.zzafu});
    }

    public static int zzei(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return n;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource zzacD;
        private DataType zzacC;
        private long zzadK = -1L;
        private long zzafp = 0L;
        private long zzafo = 0L;
        private boolean zzafv = false;
        private int zzadL = 2;
        private long zzafu = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzacD = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzacC = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            zzv.zzb((interval >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzadK = unit.toMicros(interval);
            if (!this.zzafv) {
                this.zzafp = this.zzadK / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            zzv.zzb((fastestInterval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzafv = true;
            this.zzafp = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            zzv.zzb((interval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzafo = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.zzadL = SensorRequest.zzei(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            zzv.zzb((timeout > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{timeout});
            zzv.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzafu = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            zzv.zza((this.zzacD != null || this.zzacC != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzv.zza((this.zzacC == null || this.zzacD == null || this.zzacC.equals(this.zzacD.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

