/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int zzzH;
    private final List<DataSet> zzacQ;
    private final Status zzKr;
    private final List<Bucket> zzafI;
    private int zzafJ;
    private final List<DataSource> zzada;
    private final List<DataType> zzafK;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.zzzH = versionCode;
        this.zzKr = status;
        this.zzafJ = batchCount;
        this.zzada = uniqueDataSources;
        this.zzafK = uniqueDataTypes;
        this.zzacQ = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet object : dataSets) {
            this.zzacQ.add(new DataSet(object, uniqueDataSources));
        }
        this.zzafI = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.zzafI.add(new Bucket(rawBucket, uniqueDataSources));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.zzzH = 5;
        this.zzacQ = dataSets;
        this.zzKr = status;
        this.zzafI = buckets;
        this.zzafJ = 1;
        this.zzada = new ArrayList<DataSource>();
        this.zzafK = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource object : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(object));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzacQ) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataType.getName()));
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzacQ) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataSource.getStreamIdentifier()));
    }

    public List<DataSet> getDataSets() {
        return this.zzacQ;
    }

    public List<Bucket> getBuckets() {
        return this.zzafI;
    }

    public int zzpD() {
        return this.zzafJ;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet object : dataReadResult.getDataSets()) {
            this.zza(object, this.zzacQ);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzafI);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzafI.add(bucket);
    }

    public Status getStatus() {
        return this.zzKr;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.zzc((DataReadResult)that);
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzKr.equals((Object)dataReadResult.zzKr) && zzu.equal(this.zzacQ, dataReadResult.zzacQ) && zzu.equal(this.zzafI, dataReadResult.zzafI);
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzKr, this.zzacQ, this.zzafI});
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("status", (Object)this.zzKr).zzg("dataSets", this.zzacQ.size() > 5 ? this.zzacQ.size() + " data sets" : this.zzacQ).zzg("buckets", this.zzafI.size() > 5 ? this.zzafI.size() + " buckets" : this.zzafI).toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    List<RawBucket> zzpE() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzafI.size());
        for (Bucket bucket : this.zzafI) {
            arrayList.add(new RawBucket(bucket, this.zzada, this.zzafK));
        }
        return arrayList;
    }

    List<RawDataSet> zzpF() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzacQ.size());
        for (DataSet dataSet : this.zzacQ) {
            arrayList.add(new RawDataSet(dataSet, this.zzada, this.zzafK));
        }
        return arrayList;
    }

    List<DataSource> zzoL() {
        return this.zzada;
    }

    List<DataType> zzpG() {
        return this.zzafK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

