/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.SessionDataSet;
import com.google.android.gms.fitness.result.zzj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
implements Result,
SafeParcelable {
    private final int zzzH;
    private final List<Session> zzaeK;
    private final List<SessionDataSet> zzafQ;
    private final Status zzKr;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzj();

    SessionReadResult(int versionCode, List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.zzzH = versionCode;
        this.zzaeK = sessions;
        this.zzafQ = Collections.unmodifiableList(sessionDataSets);
        this.zzKr = status;
    }

    public SessionReadResult(List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.zzzH = 3;
        this.zzaeK = sessions;
        this.zzafQ = Collections.unmodifiableList(sessionDataSets);
        this.zzKr = status;
    }

    public static SessionReadResult zzH(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<SessionDataSet> arrayList2 = new ArrayList<SessionDataSet>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzaeK;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzv.zzb((boolean)this.zzaeK.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzafQ) {
            if (!zzu.equal((Object)session, (Object)sessionDataSet.getSession()) || !dataType.equals(sessionDataSet.zzoV().getDataType())) continue;
            arrayList.add(sessionDataSet.zzoV());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzv.zzb((boolean)this.zzaeK.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzafQ) {
            if (!zzu.equal((Object)session, (Object)sessionDataSet.getSession())) continue;
            arrayList.add(sessionDataSet.zzoV());
        }
        return arrayList;
    }

    public List<SessionDataSet> zzpI() {
        return this.zzafQ;
    }

    public Status getStatus() {
        return this.zzKr;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SessionReadResult && this.zzb((SessionReadResult)that);
    }

    private boolean zzb(SessionReadResult sessionReadResult) {
        return this.zzKr.equals((Object)sessionReadResult.zzKr) && zzu.equal(this.zzaeK, sessionReadResult.zzaeK) && zzu.equal(this.zzafQ, sessionReadResult.zzafQ);
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzKr, this.zzaeK, this.zzafQ});
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("status", (Object)this.zzKr).zzg("sessions", this.zzaeK).zzg("sessionDataSets", this.zzafQ).toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }
}

