/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzh;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataSourcesRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<DataType> zzanw;
    private final List<Integer> zzapW;
    private final boolean zzapX;
    private final zzmt zzapY;
    private final String zzOZ;
    public static final Parcelable.Creator<DataSourcesRequest> CREATOR = new zzh();

    DataSourcesRequest(int versionCode, List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, IBinder callback, String packageName) {
        this.mVersionCode = versionCode;
        this.zzanw = dataTypes;
        this.zzapW = dataSourceTypes;
        this.zzapX = includeDbOnlySources;
        this.zzapY = callback == null ? null : zzmt.zza.zzbv(callback);
        this.zzOZ = packageName;
    }

    private DataSourcesRequest(Builder builder) {
        this(zzli.zzb((Object[])builder.zzapZ), Arrays.asList(zzli.zza((int[])builder.zzaqa)), builder.zzapX, null, null);
    }

    public DataSourcesRequest(DataSourcesRequest request, zzmt callback, String packageName) {
        this(request.zzanw, request.zzapW, request.zzapX, callback, packageName);
    }

    public DataSourcesRequest(List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, zzmt callback, String packageName) {
        this.mVersionCode = 3;
        this.zzanw = dataTypes;
        this.zzapW = dataSourceTypes;
        this.zzapX = includeDbOnlySources;
        this.zzapY = callback;
        this.zzOZ = packageName;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzanw);
    }

    public List<Integer> zzsl() {
        return this.zzapW;
    }

    public boolean zzsm() {
        return this.zzapX;
    }

    public IBinder zzsc() {
        return this.zzapY == null ? null : this.zzapY.asBinder();
    }

    public String getPackageName() {
        return this.zzOZ;
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzu((Object)this).zzg("dataTypes", this.zzanw).zzg("sourceTypes", this.zzapW);
        if (this.zzapX) {
            zza2.zzg("includeDbOnlySources", (Object)"true");
        }
        return zza2.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzapZ = new DataType[0];
        private int[] zzaqa = new int[]{0, 1};
        private boolean zzapX = false;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzapZ = dataTypes;
            return this;
        }

        public Builder setDataSourceTypes(int ... dataSourceTypes) {
            this.zzaqa = dataSourceTypes;
            return this;
        }

        public DataSourcesRequest build() {
            zzx.zza((this.zzapZ.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data type");
            zzx.zza((this.zzaqa.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data source type");
            return new DataSourcesRequest(this);
        }
    }
}

