/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DailyTotalRequest;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataInsertRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmr;
import com.google.android.gms.internal.zzms;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznt;

public class zzno
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient client, DataSet dataSet) {
        return this.zza(client, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzx.zzb((Object)dataSet, (Object)"Must set the data set");
        zzx.zza((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"Cannot use an empty data set");
        zzx.zzb((Object)dataSet.getDataSource().zzrF(), (Object)"Must set the app package name for the data source");
        return googleApiClient.zza((zzc.zza)new zzmm.zzc(googleApiClient){

            protected void zza(zzmm zzmm2) throws RemoteException {
                zznt zznt2 = new zznt((zzc.zzb<Status>)this);
                String string = zzmm2.getContext().getPackageName();
                ((zzmx)zzmm2.zzoA()).zza(new DataInsertRequest(dataSet, zznt2, string, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient client, final DataDeleteRequest request) {
        return client.zza((zzc.zza)new zzmm.zzc(client){

            protected void zza(zzmm zzmm2) throws RemoteException {
                zznt zznt2 = new zznt((zzc.zzb<Status>)this);
                String string = zzmm2.getContext().getPackageName();
                ((zzmx)zzmm2.zzoA()).zza(new DataDeleteRequest(request, zznt2, string));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient client, final DataReadRequest request) {
        return client.zza((zzc.zza)new zzmm.zza<DataReadResult>(client){

            protected void zza(zzmm zzmm2) throws RemoteException {
                zza zza2 = new zza((zzc.zzb)this);
                String string = zzmm2.getContext().getPackageName();
                ((zzmx)zzmm2.zzoA()).zza(new DataReadRequest(request, zza2, string));
            }

            protected DataReadResult zzJ(Status status) {
                return DataReadResult.zza(status, request);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzJ(status);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient client, final DataType dataType) {
        return client.zza((zzc.zza)new zzmm.zza<DailyTotalResult>(client){

            protected void zza(zzmm zzmm2) throws RemoteException {
                zzmr.zza zza2 = new zzmr.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.zza(dailyTotalResult);
                    }
                };
                String string = zzmm2.getContext().getPackageName();
                DailyTotalRequest dailyTotalRequest = new DailyTotalRequest(zza2, dataType, string);
                ((zzmx)zzmm2.zzoA()).zza(dailyTotalRequest);
            }

            protected DailyTotalResult zzK(Status status) {
                return DailyTotalResult.zzQ(status);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzK(status);
            }
        });
    }

    private static class zza
    extends zzms.zza {
        private final zzc.zzb<DataReadResult> zzQz;
        private int zzapd = 0;
        private DataReadResult zzape = null;

        private zza(zzc.zzb<DataReadResult> zzb2) {
            this.zzQz = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                Log.v((String)"Fitness", (String)"Received batch result");
                if (this.zzape == null) {
                    this.zzape = dataReadResult;
                } else {
                    this.zzape.zzb(dataReadResult);
                }
                ++this.zzapd;
                if (this.zzapd == this.zzape.zzsB()) {
                    this.zzQz.zzn((Object)this.zzape);
                }
            }
        }
    }
}

