/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzapM;
    private final DataType zzapL;
    private final long zzarc;
    private final long zzasJ;
    private final long zzasI;
    private final int zzard;
    private final LocationRequest zzasN;
    private final long zzasO;

    private SensorRequest(Builder builder) {
        this.zzapM = builder.zzapM;
        this.zzapL = builder.zzapL;
        this.zzarc = builder.zzarc;
        this.zzasJ = builder.zzasJ;
        this.zzasI = builder.zzasI;
        this.zzard = builder.zzard;
        this.zzasN = null;
        this.zzasO = builder.zzasO;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzasN = locationRequest;
        this.zzarc = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzasJ = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzasI = this.zzarc;
        this.zzapL = dataSource.getDataType();
        this.zzard = SensorRequest.zza(locationRequest);
        this.zzapM = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzasO = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzapM;
    }

    public DataType getDataType() {
        return this.zzapL;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzarc, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzasJ, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzasI, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzard;
    }

    public long zztg() {
        return this.zzasO;
    }

    public String toString() {
        return zzw.zzv((Object)this).zzg("dataSource", (Object)this.zzapM).zzg("dataType", (Object)this.zzapL).zzg("samplingRateMicros", (Object)this.zzarc).zzg("deliveryLatencyMicros", (Object)this.zzasI).zzg("timeOutMicros", (Object)this.zzasO).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.zza((SensorRequest)that);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzw.equal((Object)this.zzapM, (Object)sensorRequest.zzapM) && zzw.equal((Object)this.zzapL, (Object)sensorRequest.zzapL) && this.zzarc == sensorRequest.zzarc && this.zzasJ == sensorRequest.zzasJ && this.zzasI == sensorRequest.zzasI && this.zzard == sensorRequest.zzard && zzw.equal((Object)this.zzasN, (Object)sensorRequest.zzasN) && this.zzasO == sensorRequest.zzasO;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzapM, this.zzapL, this.zzarc, this.zzasJ, this.zzasI, this.zzard, this.zzasN, this.zzasO});
    }

    public static int zzff(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return n;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource zzapM;
        private DataType zzapL;
        private long zzarc = -1L;
        private long zzasJ = 0L;
        private long zzasI = 0L;
        private boolean zzasP = false;
        private int zzard = 2;
        private long zzasO = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzapM = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzapL = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            zzx.zzb((interval >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzarc = unit.toMicros(interval);
            if (!this.zzasP) {
                this.zzasJ = this.zzarc / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            zzx.zzb((fastestInterval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzasP = true;
            this.zzasJ = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            zzx.zzb((interval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzasI = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.zzard = SensorRequest.zzff(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            zzx.zzb((timeout > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{timeout});
            zzx.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzasO = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            zzx.zza((this.zzapM != null || this.zzapL != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzx.zza((this.zzapL == null || this.zzapM == null || this.zzapL.equals(this.zzapM.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

