/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient var1, DataType var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private final DataType zzatO;
        private DataSource zzatP;
        private long zzQj;
        private long zzatQ;
        private String zzatR;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.mContext = context;
            this.zzatO = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long start, long end, TimeUnit timeUnit) {
            this.zzQj = timeUnit.toMillis(start);
            this.zzatQ = timeUnit.toMillis(end);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            zzx.zzb((boolean)dataSource.getDataType().equals(this.zzatO), (String)"Data source %s is not for the data type %s", (Object[])new Object[]{dataSource, this.zzatO});
            this.zzatP = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.zzatR = packageName;
            return this;
        }

        public Intent build() {
            zzx.zza((this.zzQj > 0L ? 1 : 0) != 0, (Object)"Start time must be set");
            zzx.zza((this.zzatQ > this.zzQj ? 1 : 0) != 0, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.zzatP.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.zzQj);
            intent.putExtra("vnd.google.fitness.end_time", this.zzatQ);
            zzc.zza((SafeParcelable)this.zzatP, (Intent)intent, (String)"vnd.google.fitness.data_source");
            return this.zzl(intent);
        }

        private Intent zzl(Intent intent) {
            if (this.zzatR == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzatR);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzatR, string));
                return intent2;
            }
            return intent;
        }
    }
}

