/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzps;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int mVersionCode;
    private final String zzauA;
    private final String zzauB;
    private final String zzabv;
    private final String zzauC;
    private final int zzZU;
    private final int zzauD;
    public static final Parcelable.Creator<Device> CREATOR = new zzh();

    public static Device getLocalDevice(Context context) {
        int n = zzoo.zzaF(context);
        String string = Device.zzaB(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    private static String zzaB(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(manufacturer, model, "", uid, type, 0);
    }

    public Device(String manufacturer, String model, String version, String uid, int type, int platformType) {
        this(1, manufacturer, model, "", uid, type, platformType);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type, int platformType) {
        this.mVersionCode = versionCode;
        this.zzauA = (String)zzx.zzy((Object)manufacturer);
        this.zzauB = (String)zzx.zzy((Object)model);
        this.zzabv = "";
        this.zzauC = (String)zzx.zzy((Object)uid);
        this.zzZU = type;
        this.zzauD = platformType;
    }

    public String getManufacturer() {
        return this.zzauA;
    }

    public String getModel() {
        return this.zzauB;
    }

    public String getVersion() {
        return this.zzabv;
    }

    public String getUid() {
        return this.zzauC;
    }

    public int getType() {
        return this.zzZU;
    }

    public int zztN() {
        return this.zzauD;
    }

    private boolean zztO() {
        return this.zztN() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzauA, this.zzauB, this.zzauC);
    }

    public String zztP() {
        return this.zztO() ? this.zzauC : zzps.zzdr(this.zzauC);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.zzabv, this.zzZU, this.zzauD);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.zza((Device)that);
    }

    private boolean zza(Device device) {
        return zzw.equal((Object)this.zzauA, (Object)device.zzauA) && zzw.equal((Object)this.zzauB, (Object)device.zzauB) && zzw.equal((Object)this.zzabv, (Object)device.zzabv) && zzw.equal((Object)this.zzauC, (Object)device.zzauC) && this.zzZU == device.zzZU && this.zzauD == device.zzauD;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzauA, this.zzauB, this.zzabv, this.zzauC, this.zzZU});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }
}

