/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zzpa;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int mVersionCode;
    private final List<DataType> zzatZ;
    private final List<DataSource> zzayl;
    private final long zzQj;
    private final long zzatQ;
    private final List<DataType> zzayq;
    private final List<DataSource> zzayr;
    private final int zzauc;
    private final long zzays;
    private final DataSource zzayt;
    private final int zzayu;
    private final boolean zzayv;
    private final boolean zzayw;
    private final zzpa zzayx;
    private final List<Device> zzayy;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzf();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, IBinder callback, List<Device> filteredDevices) {
        this.mVersionCode = versionCode;
        this.zzatZ = dataTypes;
        this.zzayl = dataSources;
        this.zzQj = startTimeMillis;
        this.zzatQ = endTimeMillis;
        this.zzayq = aggregatedDataTypes;
        this.zzayr = aggregatedDataSources;
        this.zzauc = bucketType;
        this.zzays = bucketDurationMillis;
        this.zzayt = activityDataSource;
        this.zzayu = limit;
        this.zzayv = flushBeforeRead;
        this.zzayw = serverQueriesEnabled;
        this.zzayx = callback == null ? null : zzpa.zza.zzbC(callback);
        this.zzayy = filteredDevices == null ? Collections.emptyList() : filteredDevices;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzatZ, builder.zzayl, builder.zzQj, builder.zzatQ, builder.zzayq, builder.zzayr, builder.zzauc, builder.zzays, builder.zzayt, builder.zzayu, builder.zzayv, builder.zzayw, null, builder.zzayy);
    }

    public DataReadRequest(DataReadRequest request, zzpa callback) {
        this(request.zzatZ, request.zzayl, request.zzQj, request.zzatQ, request.zzayq, request.zzayr, request.zzauc, request.zzays, request.zzayt, request.zzayu, request.zzayv, request.zzayw, callback, request.zzayy);
    }

    public DataReadRequest(List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, zzpa callback, List<Device> filteredDevices) {
        this(5, dataTypes, dataSources, startTimeMillis, endTimeMillis, aggregatedDataTypes, aggregatedDataSources, bucketType, bucketDurationMillis, activityDataSource, limit, flushBeforeRead, serverQueriesEnabled, callback == null ? null : callback.asBinder(), filteredDevices);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzQj, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzatQ, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzatZ;
    }

    public List<DataSource> getDataSources() {
        return this.zzayl;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzayq;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzayr;
    }

    public int getBucketType() {
        return this.zzauc;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzays, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzayt;
    }

    public int getLimit() {
        return this.zzayu;
    }

    public boolean zzun() {
        return this.zzayw;
    }

    public boolean zzuo() {
        return this.zzayv;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.zzb((DataReadRequest)that);
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzatZ.equals(dataReadRequest.zzatZ) && this.zzayl.equals(dataReadRequest.zzayl) && this.zzQj == dataReadRequest.zzQj && this.zzatQ == dataReadRequest.zzatQ && this.zzauc == dataReadRequest.zzauc && this.zzayr.equals(dataReadRequest.zzayr) && this.zzayq.equals(dataReadRequest.zzayq) && zzw.equal((Object)this.zzayt, (Object)dataReadRequest.zzayt) && this.zzays == dataReadRequest.zzays && this.zzayw == dataReadRequest.zzayw;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzauc, this.zzQj, this.zzatQ});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzatZ.isEmpty()) {
            for (DataType object : this.zzatZ) {
                stringBuilder.append(object.zztM()).append(" ");
            }
        }
        if (!this.zzayl.isEmpty()) {
            for (DataSource dataSource : this.zzayl) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzauc != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzeI(this.zzauc));
            if (this.zzays > 0L) {
                stringBuilder.append(" >").append(this.zzays).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzayq.isEmpty()) {
            for (DataType dataType : this.zzayq) {
                stringBuilder.append(dataType.zztM()).append(" ");
            }
        }
        if (!this.zzayr.isEmpty()) {
            for (DataSource dataSource : this.zzayr) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzQj, this.zzQj, this.zzatQ, this.zzatQ));
        if (this.zzayt != null) {
            stringBuilder.append("activities: ").append(this.zzayt.toDebugString());
        }
        if (this.zzayw) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zztB() {
        return this.zzatQ;
    }

    public long zzlx() {
        return this.zzQj;
    }

    public long zzup() {
        return this.zzays;
    }

    public IBinder zzui() {
        return this.zzayx == null ? null : this.zzayx.asBinder();
    }

    public List<Device> zzuq() {
        return this.zzayy;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> zzatZ = new ArrayList<DataType>();
        private List<DataSource> zzayl = new ArrayList<DataSource>();
        private List<DataType> zzayq = new ArrayList<DataType>();
        private List<DataSource> zzayr = new ArrayList<DataSource>();
        private DataSource zzayt;
        private long zzQj;
        private long zzatQ;
        private int zzauc = 0;
        private long zzays = 0L;
        private int zzayu = 0;
        private boolean zzayv = false;
        private boolean zzayw = false;
        private List<Device> zzayy = new ArrayList<Device>();

        public Builder read(DataSource dataSource) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zzb((!this.zzayr.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzayl.contains(dataSource)) {
                this.zzayl.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzx.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzayq.contains(dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzatZ.contains(dataType)) {
                this.zzatZ.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zza((!this.zzayl.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(dataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, outputDataType});
            if (!this.zzayr.contains(dataSource)) {
                this.zzayr.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            zzx.zzb((Object)inputDataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzatZ.contains(inputDataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{inputDataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(inputDataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{inputDataType, outputDataType});
            if (!this.zzayq.contains(inputDataType)) {
                this.zzayq.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            zzx.zzb((this.zzauc == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzauc});
            zzx.zzb((duration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{duration});
            this.zzauc = 1;
            this.zzays = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzauc == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzauc});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzauc = 3;
            this.zzays = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzauc == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzauc});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzayt = activityDataSource;
            this.zzauc = 3;
            this.zzays = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzauc == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzauc});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzauc = 4;
            this.zzays = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzauc == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzauc});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzayt = activityDataSource;
            this.zzauc = 4;
            this.zzays = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzauc == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzauc});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzauc = 2;
            this.zzays = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.zzQj = timeUnit.toMillis(start);
            this.zzatQ = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzayw = true;
            return this;
        }

        public Builder setLimit(int limit) {
            zzx.zzb((limit > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{limit});
            this.zzayu = limit;
            return this;
        }

        public DataReadRequest build() {
            zzx.zza((!this.zzayl.isEmpty() || !this.zzatZ.isEmpty() || !this.zzayr.isEmpty() || !this.zzayq.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzx.zza((this.zzQj > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzQj});
            zzx.zza((this.zzatQ > 0L && this.zzatQ > this.zzQj ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzatQ});
            boolean bl = this.zzayr.isEmpty() && this.zzayq.isEmpty();
            zzx.zza((bl && this.zzauc == 0 || !bl && this.zzauc != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

