/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzu;
import com.google.android.gms.internal.zzol;
import com.google.android.gms.internal.zzpp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final Session zzatS;
    private final List<DataSet> zzaub;
    private final List<DataPoint> zzayY;
    private final zzpp zzayj;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzu();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzatS = session;
        this.zzaub = Collections.unmodifiableList(dataSets);
        this.zzayY = Collections.unmodifiableList(aggregateDataPoints);
        this.zzayj = zzpp.zza.zzbR(callback);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzatS, builder.zzaub, builder.zzayY, null);
    }

    public SessionInsertRequest(SessionInsertRequest request, zzpp callback) {
        this(request.zzatS, request.zzaub, request.zzayY, callback);
    }

    public SessionInsertRequest(Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, zzpp callback) {
        this.mVersionCode = 3;
        this.zzatS = session;
        this.zzaub = Collections.unmodifiableList(dataSets);
        this.zzayY = Collections.unmodifiableList(aggregateDataPoints);
        this.zzayj = callback;
    }

    public Session getSession() {
        return this.zzatS;
    }

    public List<DataSet> getDataSets() {
        return this.zzaub;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzayY;
    }

    public IBinder zzui() {
        return this.zzayj == null ? null : this.zzayj.asBinder();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)o);
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzw.equal((Object)this.zzatS, (Object)sessionInsertRequest.zzatS) && zzw.equal(this.zzaub, sessionInsertRequest.zzaub) && zzw.equal(this.zzayY, sessionInsertRequest.zzayY);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzatS, this.zzaub, this.zzayY});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("session", (Object)this.zzatS).zzg("dataSets", this.zzaub).zzg("aggregateDataPoints", this.zzayY).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzu.zza(this, dest, flags);
    }

    public static class Builder {
        private Session zzatS;
        private List<DataSet> zzaub = new ArrayList<DataSet>();
        private List<DataPoint> zzayY = new ArrayList<DataPoint>();
        private List<DataSource> zzayZ = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzatS = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzx.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzx.zza((!this.zzayZ.contains(dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            zzx.zzb((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzayZ.add(dataSource);
            this.zzaub.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            zzx.zzb((aggregateDataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            long l = aggregateDataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = aggregateDataPoint.getEndTime(TimeUnit.NANOSECONDS);
            zzx.zzb((l > 0L && l2 > l ? 1 : 0) != 0, (String)"Aggregate data point should have valid start and end times: %s", (Object[])new Object[]{aggregateDataPoint});
            DataSource dataSource = aggregateDataPoint.getDataSource();
            zzx.zza((!this.zzayZ.contains(dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            this.zzayZ.add(dataSource);
            this.zzayY.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzx.zza((this.zzatS != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzx.zza((this.zzatS.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzuB();
            return new SessionInsertRequest(this);
        }

        private void zze(DataPoint dataPoint) {
            this.zzg(dataPoint);
            this.zzf(dataPoint);
        }

        private void zzf(DataPoint dataPoint) {
            long l = this.zzatS.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzatS.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzol.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzx.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzg(DataPoint dataPoint) {
            long l = this.zzatS.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzatS.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzol.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzx.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzuB() {
            for (DataSet object : this.zzaub) {
                for (DataPoint dataPoint : object.getDataPoints()) {
                    this.zze(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzayY) {
                this.zze(dataPoint);
            }
        }
    }
}

