/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzaa;
import com.google.android.gms.fitness.request.zzn;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzpp;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<DataType> zzatZ;
    private final zzn zzazg;
    private final int zzazh;
    private final zzpp zzayj;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzaa();

    StartBleScanRequest(int versionCode, List<DataType> dataTypes, IBinder bleScanCallback, int timeoutSecs, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzatZ = dataTypes;
        this.zzazg = zzn.zza.zzbU(bleScanCallback);
        this.zzazh = timeoutSecs;
        this.zzayj = zzpp.zza.zzbR(callback);
    }

    private StartBleScanRequest(Builder builder) {
        this(zznh.zzb((Object[])builder.zzayE), builder.zzazg, builder.zzazh, null);
    }

    public StartBleScanRequest(StartBleScanRequest request, zzpp callback) {
        this(request.zzatZ, request.zzazg, request.zzazh, callback);
    }

    public StartBleScanRequest(List<DataType> dataTypes, zzn bleScanCallback, int timeoutSecs, zzpp callback) {
        this.mVersionCode = 4;
        this.zzatZ = dataTypes;
        this.zzazg = bleScanCallback;
        this.zzazh = timeoutSecs;
        this.zzayj = callback;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzatZ);
    }

    public int getTimeoutSecs() {
        return this.zzazh;
    }

    public IBinder zzuE() {
        return this.zzazg.asBinder();
    }

    public IBinder zzui() {
        return this.zzayj == null ? null : this.zzayj.asBinder();
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("dataTypes", this.zzatZ).zzg("timeoutSecs", (Object)this.zzazh).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzaa.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzayE = new DataType[0];
        private zzn zzazg;
        private int zzazh = 10;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzayE = dataTypes;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzug().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzn zzn2) {
            this.zzazg = zzn2;
            return this;
        }

        public Builder setTimeoutSecs(int stopTimeSecs) {
            zzx.zzb((stopTimeSecs > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzx.zzb((stopTimeSecs <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzazh = stopTimeSecs;
            return this;
        }

        public StartBleScanRequest build() {
            zzx.zza((this.zzazg != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

