/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zzow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final long zzRD;
    private final long zzavV;
    private final List<DataSource> zzaAF;
    private final List<DataType> zzawe;
    private final List<Session> zzaAG;
    private final boolean zzaAH;
    private final boolean zzaAI;
    private final zzow zzaAD;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzd();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzRD = startTimeMillis;
        this.zzavV = endTimeMillis;
        this.zzaAF = Collections.unmodifiableList(dataSources);
        this.zzawe = Collections.unmodifiableList(dataTypes);
        this.zzaAG = sessions;
        this.zzaAH = deleteAllData;
        this.zzaAI = deleteAllSessions;
        this.zzaAD = zzow.zza.zzbR(callback);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzRD, builder.zzavV, builder.zzaAF, builder.zzawe, builder.zzaAG, builder.zzaAH, builder.zzaAI, null);
    }

    public DataDeleteRequest(DataDeleteRequest request, zzow callback) {
        this(request.zzRD, request.zzavV, request.zzaAF, request.zzawe, request.zzaAG, request.zzaAH, request.zzaAI, callback);
    }

    public DataDeleteRequest(long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, zzow callback) {
        this.mVersionCode = 3;
        this.zzRD = startTimeMillis;
        this.zzavV = endTimeMillis;
        this.zzaAF = Collections.unmodifiableList(dataSources);
        this.zzawe = Collections.unmodifiableList(dataTypes);
        this.zzaAG = sessions;
        this.zzaAH = deleteAllData;
        this.zzaAI = deleteAllSessions;
        this.zzaAD = callback;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzRD, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzavV, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzaAF;
    }

    public List<DataType> getDataTypes() {
        return this.zzawe;
    }

    public List<Session> getSessions() {
        return this.zzaAG;
    }

    public boolean deleteAllData() {
        return this.zzaAH;
    }

    public boolean deleteAllSessions() {
        return this.zzaAI;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)o);
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzRD == dataDeleteRequest.zzRD && this.zzavV == dataDeleteRequest.zzavV && zzw.equal(this.zzaAF, dataDeleteRequest.zzaAF) && zzw.equal(this.zzawe, dataDeleteRequest.zzawe) && zzw.equal(this.zzaAG, dataDeleteRequest.zzaAG) && this.zzaAH == dataDeleteRequest.zzaAH && this.zzaAI == dataDeleteRequest.zzaAI;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzRD, this.zzavV});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("startTimeMillis", (Object)this.zzRD).zzg("endTimeMillis", (Object)this.zzavV).zzg("dataSources", this.zzaAF).zzg("dateTypes", this.zzawe).zzg("sessions", this.zzaAG).zzg("deleteAllData", (Object)this.zzaAH).zzg("deleteAllSessions", (Object)this.zzaAI).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean zzuL() {
        return this.zzaAH;
    }

    public boolean zzuM() {
        return this.zzaAI;
    }

    public long zzud() {
        return this.zzavV;
    }

    public long zzlO() {
        return this.zzRD;
    }

    public IBinder getCallbackBinder() {
        return this.zzaAD == null ? null : this.zzaAD.asBinder();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzd.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzRD;
        private long zzavV;
        private List<DataSource> zzaAF = new ArrayList<DataSource>();
        private List<DataType> zzawe = new ArrayList<DataType>();
        private List<Session> zzaAG = new ArrayList<Session>();
        private boolean zzaAH = false;
        private boolean zzaAI = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            zzx.zzb((startTime > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{startTime});
            zzx.zzb((endTime > startTime ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{endTime});
            this.zzRD = timeUnit.toMillis(startTime);
            this.zzavV = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            zzx.zzb((boolean)this.zzawe.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzx.zzb((boolean)this.zzaAF.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzaAH = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzx.zzb((!this.zzaAH ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzx.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzawe.contains(dataType)) {
                this.zzawe.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzx.zzb((!this.zzaAH ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzx.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzaAF.contains(dataSource)) {
                this.zzaAF.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzx.zzb((!this.zzaAI ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzx.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzx.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzaAG.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzx.zzb((boolean)this.zzaAG.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzaAI = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzx.zza((this.zzRD > 0L && this.zzavV > this.zzRD ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzaAH || !this.zzaAF.isEmpty() || !this.zzawe.isEmpty();
            boolean bl2 = this.zzaAI || !this.zzaAG.isEmpty();
            zzx.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzuN();
            return new DataDeleteRequest(this);
        }

        private void zzuN() {
            if (this.zzaAG.isEmpty()) {
                return;
            }
            for (Session session : this.zzaAG) {
                zzx.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzRD && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzavV ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.zzRD, this.zzavV});
            }
        }
    }
}

