/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zzoh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int mVersionCode;
    private final List<DataType> zzawe;
    private final List<DataSource> zzaAF;
    private final long zzRD;
    private final long zzavV;
    private final List<DataType> zzaAK;
    private final List<DataSource> zzaAL;
    private final int zzawh;
    private final long zzaAM;
    private final DataSource zzaAN;
    private final int zzaAO;
    private final boolean zzaAP;
    private final boolean zzaAQ;
    private final zzoh zzaAR;
    private final List<Device> zzaAS;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzf();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, IBinder callback, List<Device> filteredDevices) {
        this.mVersionCode = versionCode;
        this.zzawe = dataTypes;
        this.zzaAF = dataSources;
        this.zzRD = startTimeMillis;
        this.zzavV = endTimeMillis;
        this.zzaAK = aggregatedDataTypes;
        this.zzaAL = aggregatedDataSources;
        this.zzawh = bucketType;
        this.zzaAM = bucketDurationMillis;
        this.zzaAN = activityDataSource;
        this.zzaAO = limit;
        this.zzaAP = flushBeforeRead;
        this.zzaAQ = serverQueriesEnabled;
        this.zzaAR = callback == null ? null : zzoh.zza.zzbC(callback);
        this.zzaAS = filteredDevices == null ? Collections.emptyList() : filteredDevices;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzawe, builder.zzaAF, builder.zzRD, builder.zzavV, builder.zzaAK, builder.zzaAL, builder.zzawh, builder.zzaAM, builder.zzaAN, builder.zzaAO, builder.zzaAP, builder.zzaAQ, null, builder.zzaAS);
    }

    public DataReadRequest(DataReadRequest request, zzoh callback) {
        this(request.zzawe, request.zzaAF, request.zzRD, request.zzavV, request.zzaAK, request.zzaAL, request.zzawh, request.zzaAM, request.zzaAN, request.zzaAO, request.zzaAP, request.zzaAQ, callback, request.zzaAS);
    }

    public DataReadRequest(List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, zzoh callback, List<Device> filteredDevices) {
        this(5, dataTypes, dataSources, startTimeMillis, endTimeMillis, aggregatedDataTypes, aggregatedDataSources, bucketType, bucketDurationMillis, activityDataSource, limit, flushBeforeRead, serverQueriesEnabled, callback == null ? null : callback.asBinder(), filteredDevices);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzRD, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzavV, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzawe;
    }

    public List<DataSource> getDataSources() {
        return this.zzaAF;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzaAK;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzaAL;
    }

    public int getBucketType() {
        return this.zzawh;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaAM, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzaAN;
    }

    public int getLimit() {
        return this.zzaAO;
    }

    public boolean zzuP() {
        return this.zzaAQ;
    }

    public boolean zzuQ() {
        return this.zzaAP;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.zzb((DataReadRequest)that);
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzawe.equals(dataReadRequest.zzawe) && this.zzaAF.equals(dataReadRequest.zzaAF) && this.zzRD == dataReadRequest.zzRD && this.zzavV == dataReadRequest.zzavV && this.zzawh == dataReadRequest.zzawh && this.zzaAL.equals(dataReadRequest.zzaAL) && this.zzaAK.equals(dataReadRequest.zzaAK) && zzw.equal((Object)this.zzaAN, (Object)dataReadRequest.zzaAN) && this.zzaAM == dataReadRequest.zzaAM && this.zzaAQ == dataReadRequest.zzaAQ;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzawh, this.zzRD, this.zzavV});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzawe.isEmpty()) {
            for (DataType object : this.zzawe) {
                stringBuilder.append(object.zzuo()).append(" ");
            }
        }
        if (!this.zzaAF.isEmpty()) {
            for (DataSource dataSource : this.zzaAF) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzawh != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzeM(this.zzawh));
            if (this.zzaAM > 0L) {
                stringBuilder.append(" >").append(this.zzaAM).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzaAK.isEmpty()) {
            for (DataType dataType : this.zzaAK) {
                stringBuilder.append(dataType.zzuo()).append(" ");
            }
        }
        if (!this.zzaAL.isEmpty()) {
            for (DataSource dataSource : this.zzaAL) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzRD, this.zzRD, this.zzavV, this.zzavV));
        if (this.zzaAN != null) {
            stringBuilder.append("activities: ").append(this.zzaAN.toDebugString());
        }
        if (this.zzaAQ) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzud() {
        return this.zzavV;
    }

    public long zzlO() {
        return this.zzRD;
    }

    public long zzuR() {
        return this.zzaAM;
    }

    public IBinder getCallbackBinder() {
        return this.zzaAR == null ? null : this.zzaAR.asBinder();
    }

    public List<Device> zzuS() {
        return this.zzaAS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> zzawe = new ArrayList<DataType>();
        private List<DataSource> zzaAF = new ArrayList<DataSource>();
        private List<DataType> zzaAK = new ArrayList<DataType>();
        private List<DataSource> zzaAL = new ArrayList<DataSource>();
        private DataSource zzaAN;
        private long zzRD;
        private long zzavV;
        private int zzawh = 0;
        private long zzaAM = 0L;
        private int zzaAO = 0;
        private boolean zzaAP = false;
        private boolean zzaAQ = false;
        private List<Device> zzaAS = new ArrayList<Device>();

        public Builder read(DataSource dataSource) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zzb((!this.zzaAL.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzaAF.contains(dataSource)) {
                this.zzaAF.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzx.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzaAK.contains(dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzawe.contains(dataType)) {
                this.zzawe.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zza((!this.zzaAF.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(dataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, outputDataType});
            if (!this.zzaAL.contains(dataSource)) {
                this.zzaAL.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            zzx.zzb((Object)inputDataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzawe.contains(inputDataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{inputDataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(inputDataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{inputDataType, outputDataType});
            if (!this.zzaAK.contains(inputDataType)) {
                this.zzaAK.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            zzx.zzb((this.zzawh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzawh});
            zzx.zzb((duration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{duration});
            this.zzawh = 1;
            this.zzaAM = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzawh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzawh});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzawh = 3;
            this.zzaAM = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzawh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzawh});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzaAN = activityDataSource;
            this.zzawh = 3;
            this.zzaAM = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzawh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzawh});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzawh = 4;
            this.zzaAM = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzawh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzawh});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzaAN = activityDataSource;
            this.zzawh = 4;
            this.zzaAM = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzawh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzawh});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzawh = 2;
            this.zzaAM = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.zzRD = timeUnit.toMillis(start);
            this.zzavV = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaAQ = true;
            return this;
        }

        public Builder setLimit(int limit) {
            zzx.zzb((limit > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{limit});
            this.zzaAO = limit;
            return this;
        }

        public DataReadRequest build() {
            zzx.zza((!this.zzaAF.isEmpty() || !this.zzawe.isEmpty() || !this.zzaAL.isEmpty() || !this.zzaAK.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzx.zza((this.zzRD > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzRD});
            zzx.zza((this.zzavV > 0L && this.zzavV > this.zzRD ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzavV});
            boolean bl = this.zzaAL.isEmpty() && this.zzaAK.isEmpty();
            zzx.zza((bl && this.zzawh == 0 || !bl && this.zzawh != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

