/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzk;
import com.google.android.gms.internal.zzow;

public class DataUpdateListenerRegistrationRequest
implements SafeParcelable {
    private final int mVersionCode;
    private DataSource zzavU;
    private DataType zzavT;
    private final PendingIntent mPendingIntent;
    private final zzow zzaAD;
    public static final Parcelable.Creator<DataUpdateListenerRegistrationRequest> CREATOR = new zzk();

    DataUpdateListenerRegistrationRequest(int versionCode, DataSource dataSource, DataType dataType, PendingIntent intent, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzavU = dataSource;
        this.zzavT = dataType;
        this.mPendingIntent = intent;
        this.zzaAD = zzow.zza.zzbR(callback);
    }

    public DataUpdateListenerRegistrationRequest(DataSource dataSource, DataType dataType, PendingIntent pendingIntent, IBinder callback) {
        this.mVersionCode = 1;
        this.zzavU = dataSource;
        this.zzavT = dataType;
        this.mPendingIntent = pendingIntent;
        this.zzaAD = zzow.zza.zzbR(callback);
    }

    private DataUpdateListenerRegistrationRequest(Builder builder) {
        this(builder.zzavU, builder.zzavT, builder.mPendingIntent, null);
    }

    public DataSource getDataSource() {
        return this.zzavU;
    }

    public DataType getDataType() {
        return this.zzavT;
    }

    public PendingIntent getIntent() {
        return this.mPendingIntent;
    }

    public IBinder getCallbackBinder() {
        return this.zzaAD == null ? null : this.zzaAD.asBinder();
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("dataSource", (Object)this.zzavU).zzg("dataType", (Object)this.zzavT).zzg("pendingIntent", (Object)this.mPendingIntent).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzk.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataUpdateListenerRegistrationRequest && this.zzb((DataUpdateListenerRegistrationRequest)that);
    }

    private boolean zzb(DataUpdateListenerRegistrationRequest dataUpdateListenerRegistrationRequest) {
        return zzw.equal((Object)this.zzavU, (Object)dataUpdateListenerRegistrationRequest.zzavU) && zzw.equal((Object)this.zzavT, (Object)dataUpdateListenerRegistrationRequest.zzavT) && zzw.equal((Object)this.mPendingIntent, (Object)dataUpdateListenerRegistrationRequest.mPendingIntent);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzavU, this.zzavT, this.mPendingIntent});
    }

    public static class Builder {
        private DataSource zzavU;
        private DataType zzavT;
        private PendingIntent mPendingIntent;

        public Builder setDataSource(DataSource dataSource) throws NullPointerException {
            zzx.zzz((Object)dataSource);
            this.zzavU = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            zzx.zzz((Object)dataType);
            this.zzavT = dataType;
            return this;
        }

        public Builder setPendingIntent(PendingIntent pendingIntent) {
            zzx.zzz((Object)pendingIntent);
            this.mPendingIntent = pendingIntent;
            return this;
        }

        public DataUpdateListenerRegistrationRequest build() {
            zzx.zza((this.zzavU != null || this.zzavT != null ? 1 : 0) != 0, (Object)"Set either dataSource or dataTYpe");
            zzx.zzb((Object)this.mPendingIntent, (Object)"pendingIntent must be set");
            return new DataUpdateListenerRegistrationRequest(this);
        }
    }
}

